/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.mongodb;

import com.inet.lib.json.Json;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.mongodb.MongoDbPersistence;
import com.inet.persistence.mongodb.MongoDbTagIndex;
import com.inet.persistence.spi.searchlistener.SearchListenerContainer;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.TagIndex;
import com.mongodb.MongoNamespace;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.RenameCollectionOptions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bson.Document;

public class MongoDbSearchIndexPersistence<ID>
implements SearchIndexPersistence<ID> {
    static final String ATTRIBUTES = "attributes";
    static final String ATTR_DATA = "data";
    static final String TAG = "tag";
    static final String ID = "id";
    static final String VALUE = "value";
    private String indexName;
    private IndexSearchEngine<ID> engine;
    private MongoCollection<Document> collection;

    MongoDbSearchIndexPersistence(String indexName) {
        this.indexName = indexName;
    }

    private String getCollectionName() {
        return "index." + this.indexName;
    }

    @Nonnull
    MongoCollection<Document> getCollection() {
        if (this.collection == null) {
            MongoDatabase db = MongoDbPersistence.getDatabase();
            this.collection = db.getCollection(this.getCollectionName());
            this.createIndex();
        }
        return this.collection;
    }

    private void createIndex() {
        this.collection.createIndex(Indexes.ascending((String[])new String[]{TAG, VALUE}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{ATTRIBUTES}), new IndexOptions().sparse(true));
    }

    public MongoDbTagIndex<ID> createTag(@Nonnull SearchTag searchTag) {
        SearchListenerContainer searchListeners = MongoDbPersistence.getSearchListenerManager().createContainer(this.indexName, searchTag);
        return new MongoDbTagIndex<ID>(this.getCollection(), searchTag, this.engine, searchListeners);
    }

    public void deleteTag(String tag) {
        this.getCollection().deleteMany(Filters.eq((String)ATTRIBUTES, (Object)tag));
        this.getCollection().deleteMany(Filters.eq((String)TAG, (Object)tag));
    }

    public void setEngine(IndexSearchEngine<ID> engine) {
        this.engine = engine;
    }

    public boolean needReindex() {
        FindIterable find = this.getCollection().find().filter(Filters.eq((String)ATTRIBUTES, (Object)"reindex")).limit(1);
        return find.iterator().hasNext();
    }

    public void markForReindex() throws IOException {
        Document doc = new Document();
        doc.put(ATTRIBUTES, (Object)"reindex");
        this.getCollection().insertOne((Object)doc);
    }

    public Map<String, String> loadIndexAttributes() {
        FindIterable find = this.getCollection().find().filter(Filters.eq((String)ATTRIBUTES, (Object)"index")).limit(1);
        Document doc = (Document)find.first();
        if (doc != null) {
            try {
                String data = doc.getString((Object)ATTR_DATA);
                if (data != null) {
                    return (Map)new Json().fromJson(data, Map.class);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new HashMap<String, String>();
    }

    public void saveIndexAttributes(@Nonnull Map<String, String> attrs) throws IOException {
        Document doc = new Document();
        doc.put(ATTRIBUTES, (Object)"index");
        doc.put(ATTR_DATA, (Object)new Json().toJson(attrs));
        this.getCollection().insertOne((Object)doc);
    }

    public String getName() {
        return this.indexName;
    }

    public void saveOutstanding() {
    }

    public SearchIndexPersistence<ID> copy() throws IOException {
        this.markForReindex();
        return new MongoDbSearchIndexPersistence<ID>(this.indexName + "_copy");
    }

    public void replaceWith(SearchIndexPersistence<ID> copy, Map<SearchTag, TagIndex<ID>> searchTags) throws IOException {
        MongoDbSearchIndexPersistence source = (MongoDbSearchIndexPersistence)copy;
        source.getCollection().renameCollection(new MongoNamespace(MongoDbPersistence.getDatabase().getName(), this.getCollectionName()), new RenameCollectionOptions().dropTarget(true));
        for (Map.Entry<SearchTag, TagIndex<ID>> entry : searchTags.entrySet()) {
            if (entry.getKey().getDataType() == SearchDataType.Api) continue;
            ((MongoDbTagIndex)entry.getValue()).setNewCollection(this.getCollection());
        }
    }

    public void delete() {
        MongoDatabase db = MongoDbPersistence.getDatabase();
        db.getCollection(this.getCollectionName()).drop();
    }
}

