/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.BytesByReference;
import com.inet.odbc.OdbcCallableStatement;
import com.inet.odbc.OdbcDatabaseMetaData;
import com.inet.odbc.OdbcLibrary;
import com.inet.odbc.OdbcPreparedStatement;
import com.inet.odbc.OdbcStatement;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;

class OdbcConnection
implements Connection {
    private final Properties info;
    private SQLWarning warnings;
    private Pointer env;
    private Pointer hDbc;
    private boolean isClosed;
    private OdbcDatabaseMetaData metaData = new OdbcDatabaseMetaData(this);
    private IntByReference intRef = new IntByReference();
    private BytesByReference bytesMaxSqlLengthRef = new BytesByReference(512);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OdbcConnection(Properties info) throws SQLException {
        this.info = info;
        Class<OdbcConnection> clazz = OdbcConnection.class;
        synchronized (OdbcConnection.class) {
            PointerByReference ref = new PointerByReference();
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLAllocHandle((short)1, null, ref));
            this.env = ref.getValue();
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLSetEnvAttr(this.env, 200, 3, 0));
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLAllocHandle((short)2, this.env, ref));
            this.hDbc = ref.getValue();
            String connectStr = this.buildConnectString();
            byte[] connectData = this.toBytes(connectStr);
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLDriverConnect(this.hDbc, Pointer.NULL, connectData, (short)-3, null, (short)0, new ShortByReference(), (short)0));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    Object getLock() {
        return this.hDbc != null ? this.hDbc : this;
    }

    BytesByReference getBytesMaxSqlLengthRef() {
        return this.bytesMaxSqlLengthRef;
    }

    IntByReference getIntRef() {
        return this.intRef;
    }

    private void checkSqlReturn(short ret) throws SQLException {
        this.warnings = null;
        this.warnings = this.checkSqlReturn(ret, Pointer.NULL);
    }

    SQLWarning checkSqlReturn(short ret, Pointer hstmt) throws SQLException {
        Object object = this.getLock();
        synchronized (object) {
            switch (ret) {
                case 0: {
                    return null;
                }
                case -1: 
                case 1: {
                    ShortByReference msgLength;
                    byte[] msg;
                    IntByReference vendorCode;
                    byte[] sqlState;
                    short errRet;
                    SQLException first = null;
                    SQLException last = null;
                    while ((errRet = OdbcLibrary.ODBC.SQLError(this.env, this.hDbc, hstmt, sqlState = new byte[6 * OdbcLibrary.FACTOR], vendorCode = new IntByReference(), msg = new byte[512 * OdbcLibrary.FACTOR], (short)512, msgLength = new ShortByReference())) == 0) {
                        String msgStr = this.toString(msg, msgLength.getValue() * OdbcLibrary.FACTOR);
                        String stateStr = this.toString(sqlState, 5 * OdbcLibrary.FACTOR);
                        int code = vendorCode.getValue();
                        SQLException nextEx = ret == -1 ? new SQLException(msgStr, stateStr, code) : new SQLWarning(msgStr, stateStr, code);
                        if (last != null) {
                            last.setNextException(nextEx);
                        }
                        last = nextEx;
                        if (first != null) continue;
                        first = last;
                    }
                    if (first == null) {
                        first = new SQLException("General error", "S1000");
                    }
                    if (ret == -1) {
                        throw first;
                    }
                    return (SQLWarning)first;
                }
                case -2: {
                    throw new SQLException("Invalid Handle");
                }
                case 100: {
                    throw new SQLException("No data found");
                }
            }
            throw new SQLException("Unknown return value: " + ret);
        }
    }

    String getConfigString(String key) {
        return this.info.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInfoString(short infoType) throws SQLException {
        int bufferSize = 16383 * OdbcLibrary.FACTOR;
        BytesByReference msg = new BytesByReference(bufferSize);
        ShortByReference msgLength = new ShortByReference();
        Object object = this.getLock();
        synchronized (object) {
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLGetInfo(this.hDbc, infoType, msg, (short)bufferSize, msgLength));
        }
        short length = msgLength.getValue();
        if (length >= bufferSize) {
            throw new SQLException("Buffer exceeds available space: " + length);
        }
        byte[] bytes = msg.getValue(length);
        return this.toString(bytes, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    short getInfoShort(short infoType) throws SQLException {
        ShortByReference msg = new ShortByReference();
        Object object = this.getLock();
        synchronized (object) {
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLGetInfo(this.hDbc, infoType, (ByReference)msg, (short)Short.MAX_VALUE, null));
        }
        return msg.getValue();
    }

    String toAnsiString(byte[] bytes, int length) {
        return new String(bytes, 0, length);
    }

    String toString(byte[] bytes, int length) {
        return new String(bytes, 0, length, OdbcLibrary.CHARSET);
    }

    byte[] toBytes(String str) {
        return str.getBytes(OdbcLibrary.CHARSET);
    }

    byte[] toAnsiBytes(String str) {
        return str.getBytes();
    }

    byte[] toBytesWithNull(String str) {
        if (str == null) {
            return null;
        }
        return this.toBytes(str);
    }

    private String buildConnectString() {
        StringBuilder builder = new StringBuilder();
        String dsn = this.info.getProperty("jdbcurl").substring(10);
        String dsnLower = dsn.toLowerCase();
        boolean isDSN = dsnLower.indexOf("driver=") < 0 && dsnLower.indexOf("dsn=") < 0;
        String password = this.info.getProperty("password");
        String user = this.info.getProperty("user");
        if (isDSN) {
            builder.append("DSN=").append(dsn).append(';');
            if (password != null) {
                builder.append("PWD=").append(password).append(';');
            }
            if (user != null) {
                builder.append("UID=").append(user).append(';');
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(dsn, ";");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.startsWith("PWD=") && password != null) {
                    builder.append("PWD=").append(password).append(';');
                    password = null;
                    continue;
                }
                if (token.startsWith("UID=") && user != null) {
                    builder.append("UID=").append(user).append(';');
                    user = null;
                    continue;
                }
                builder.append(token).append(";");
            }
            if (password != null) {
                builder.append("PWD=").append(password).append(';');
            }
            if (user != null) {
                builder.append("UID=").append(user).append(';');
            }
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        builder.append('\u0000');
        return builder.toString();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isClosed) {
            Object object = this.getLock();
            synchronized (object) {
                this.isClosed = true;
                try {
                    this.checkSqlReturn(OdbcLibrary.ODBC.SQLDisconnect(this.hDbc));
                }
                catch (Exception ex) {
                    ex.printStackTrace(DriverManager.getLogWriter());
                }
                try {
                    this.checkSqlReturn(OdbcLibrary.ODBC.SQLFreeConnect(this.hDbc));
                }
                catch (Exception ex) {
                    ex.printStackTrace(DriverManager.getLogWriter());
                }
                try {
                    this.checkSqlReturn(OdbcLibrary.ODBC.SQLFreeEnv(this.env));
                }
                catch (Exception ex) {
                    ex.printStackTrace(DriverManager.getLogWriter());
                }
            }
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void commit() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OdbcStatement createStatement() throws SQLException {
        Object object = this.getLock();
        synchronized (object) {
            PointerByReference ref = new PointerByReference();
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLAllocStmt(this.hDbc, ref));
            Pointer hStmt = ref.getValue();
            return new OdbcStatement(this, hStmt);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        Object object = this.getLock();
        synchronized (object) {
            BytesByReference buffer = this.getBytesMaxSqlLengthRef();
            IntByReference valueLength = this.getIntRef();
            OdbcLibrary.ODBC.SQLGetConnectAttr(this.hDbc, 109, buffer, 512, valueLength);
            int length = valueLength.getValue();
            return this.toString(buffer.getValue(length), length);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        Object object = this.getLock();
        synchronized (object) {
            PointerByReference ref = new PointerByReference();
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLAllocHandle((short)3, this.hDbc, ref));
            Pointer hStmt = ref.getValue();
            return new OdbcCallableStatement(this, hStmt, sql);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Object object = this.getLock();
        synchronized (object) {
            PointerByReference ref = new PointerByReference();
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLAllocHandle((short)3, this.hDbc, ref));
            Pointer hStmt = ref.getValue();
            return new OdbcPreparedStatement(this, hStmt, sql);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        Object object = this.getLock();
        synchronized (object) {
            byte[] catalogBytes = this.toBytes(catalog);
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLSetConnectAttr(this.hDbc, 109, catalogBytes, catalogBytes.length));
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(this.getClass().getName() + " does not implements " + iface.getName() + ".", "01000");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

