/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public class GrantFirstUserAllPermissionsListener
extends UserEventAdapter {
    @Override
    public void userAccountCreated(@Nonnull UserAccount userAccount) {
        UserAccountType userAccountType = userAccount.getAccountType();
        if (userAccountType != UserAccountType.Standard) {
            return;
        }
        UserManager userManager = UserManager.getInstance();
        UserAccount userAccount2 = userManager.getUserAccount(UserManager.MASTER_ACCOUNT_ID);
        if (userAccount2 != null && userAccount2.getLastAccess() != 0L) {
            return;
        }
        SearchCommand searchCommand = new SearchCommand("useraccounttype", SearchCondition.SearchTermOperator.Equals, UserAccountType.Standard.name());
        searchCommand.setResultLimit(3);
        Set<GUID> set = userManager.getSearchEngine().simpleSearch(searchCommand);
        int n2 = set.size();
        if (n2 > 1) {
            return;
        }
        GUID gUID = userAccount.getID();
        Set<Permission> set2 = Set.of(Permission.values());
        userManager.updateUserPermissions(gUID, set2, Collections.emptySet());
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        GUID gUID2 = userGroupManager.getGroup(UsersAndGroups.GROUP_ADMINISTRATORS.getName(), UsersAndGroups.GROUPTYPE_ADMIN).getID();
        userGroupManager.addUserToGroup(gUID, gUID2, new MembershipType[0]);
    }
}

