/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups.search;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.groups.search.SearchTagGroupName;
import com.inet.usersandgroups.groups.search.SearchTagGroupPermissions;
import com.inet.usersandgroups.groups.search.SearchTagGroupType;
import com.inet.usersandgroups.groups.search.SearchTagMemberId;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class UserGroupSearchDataCache
extends AbstractSearchDataCache<GUID> {
    private Map<GUID, UserGroupInfo> a;
    private List<UserGroupField<Object>> b;
    private List<SearchTag> c;

    public UserGroupSearchDataCache(Map<GUID, UserGroupInfo> groupInfoCache, List<UserGroupField<Object>> userGroupFields) {
        if (groupInfoCache == null) {
            throw new IllegalArgumentException("groupInfoCache must not be null");
        }
        if (userGroupFields == null) {
            throw new IllegalArgumentException("list of fields must not be null");
        }
        this.a = groupInfoCache;
        this.b = Collections.unmodifiableList(userGroupFields.stream().filter(userGroupField -> userGroupField.getSearchTag() != null).collect(Collectors.toList()));
        List list = this.b.stream().map(Field::getSearchTag).collect(Collectors.toList());
        list.add(new SearchTagGroupName());
        list.add(new SearchTagGroupType());
        list.add(new SearchTagMemberId());
        list.add(new SearchTagGroupPermissions());
        this.c = Collections.unmodifiableList(list);
    }

    List<SearchTag> a() {
        return this.c;
    }

    @Override
    public Map<String, Object> getCacheEntry(@Nonnull GUID groupID) {
        UserGroupInfo userGroupInfo = this.a.get(groupID);
        if (userGroupInfo == null) {
            return null;
        }
        return this.toMap(userGroupInfo);
    }

    public Map<GUID, Map<String, Object>> getCacheEntries(@Nonnull List<GUID> groupIDs, int limit) {
        HashMap<GUID, Map<String, Object>> hashMap = new HashMap<GUID, Map<String, Object>>();
        for (GUID gUID : groupIDs) {
            if (hashMap.size() == limit) {
                return hashMap;
            }
            UserGroupInfo userGroupInfo = this.a.get(gUID);
            if (userGroupInfo == null) continue;
            hashMap.put(userGroupInfo.getID(), this.toMap(userGroupInfo));
        }
        return hashMap;
    }

    @Override
    public Iterator<GUID> iterator() {
        return this.a.keySet().stream().filter(gUID -> this.a.get(gUID).isActive()).iterator();
    }

    public void groupCreated(UserGroupInfo groupInfo) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        GUID gUID = groupInfo.getID();
        Map<String, Object> map = this.toMap(groupInfo);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryAdded(gUID, map);
        }
    }

    public void groupDeleted(UserGroupInfo groupInfo) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        GUID gUID = groupInfo.getID();
        Map<String, Object> map = this.toMap(groupInfo);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryRemoved(gUID, map);
        }
    }

    public void groupUpdated(UserGroupInfo oldGroupInfo, UserGroupInfo newGroupInfo) {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        GUID gUID = oldGroupInfo.getID();
        Map<String, Object> map = this.toMap(oldGroupInfo);
        Map<String, Object> map2 = this.toMap(newGroupInfo);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged(gUID, map, map2);
        }
    }

    protected Map<String, Object> toMap(UserGroupInfo groupInfo) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("groupname", groupInfo.getID().toString());
        hashMap.put("grouptype", groupInfo.getType().getName());
        hashMap.put("memberid", groupInfo.getMemberIDs());
        Set<Permission> set = UsersAndGroups.GROUPID_ADMIN.equals(groupInfo.getID()) ? new HashSet<Permission>(Arrays.asList(Permission.values())) : Permission.filterOutPermissionsWithoutGrantedAncestorPermissions(groupInfo.getPermissionsIncludingInactive());
        hashMap.put("permissions", set);
        for (UserGroupField<Object> userGroupField : this.b) {
            hashMap.put(userGroupField.getKey(), groupInfo.getValue(userGroupField));
        }
        return hashMap;
    }

    public void indexAllPermissionsForGroupAdministrators() {
        SearchDataCacheChangeListener<ID>[] searchDataCacheChangeListenerArray;
        Map<String, Object> map = Collections.emptyMap();
        HashSet<Permission> hashSet = new HashSet<Permission>(Arrays.asList(Permission.values()));
        Map<String, Object> map2 = Collections.singletonMap("permissions", hashSet);
        for (SearchDataCacheChangeListener<GUID> searchDataCacheChangeListener : searchDataCacheChangeListenerArray = this.getListeners()) {
            searchDataCacheChangeListener.entryChanged(UsersAndGroups.GROUPID_ADMIN, map, map2);
        }
    }
}

