/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin;

import com.inet.annotations.PublicApi;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.classloader.BaseLocator;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.globalbanner.GlobalBanner;
import com.inet.globalbanner.GlobalBannerManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.DebugUtils;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.logging.StartupLogger;
import com.inet.logging.SystemEventLog;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.Persistence;
import com.inet.persistence.file.FilePersistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.DependencyClassLoader;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.InetApplicationDescription;
import com.inet.plugin.InetcoreServerPlugin;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.PluginEvent;
import com.inet.plugin.PluginFilter;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.FileResourceFile;
import com.inet.plugin.fs.PersistenceResourceFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.VirtualFile;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.veto.VetoManager;
import com.inet.thread.ThreadUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class ServerPluginManager {
    public static final boolean DEBUG;
    private static final String PLUGINS = "plugins";
    private Map<String, ServerPluginDescription> a = new HashMap<String, ServerPluginDescription>();
    private Set<String> b = this.a.keySet();
    private Map<String, Object> c = new ConcurrentHashMap<String, Object>();
    private final ConcurrentHashMap<Class<?>, List<?>> d = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, List<?>> e = new ConcurrentHashMap();
    private ServerPluginManagerState f = ServerPluginManagerState.PRE_INIT;
    private Throwable g;
    private File h;
    private boolean i;
    private ResourceFile j;
    private List<ResourceFile> k;
    private ResourceFile l;
    private String m;
    private Properties n;
    private PluginFilter o;
    private Map<String, Boolean> p;
    private boolean q;
    private static ServerPluginManager r;
    public static final boolean IS_SERVLET_API;

    protected ServerPluginManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerPluginManager getInstance() {
        if (r != null) return r;
        Class<ServerPluginManager> clazz = ServerPluginManager.class;
        synchronized (ServerPluginManager.class) {
            if (r != null) return r;
            r = new ServerPluginManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return r;
        }
    }

    public void reset() {
        if (this.f == ServerPluginManagerState.PRE_INIT || this.f == ServerPluginManagerState.RESET) {
            return;
        }
        LogManager.getConfigLogger().info("Reset plugins");
        this.f = ServerPluginManagerState.RESET;
        if (this.b != null) {
            Iterator<String> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                try {
                    String string = iterator.next();
                    ServerPluginDescription serverPluginDescription = this.a.get(string);
                    ServerPlugin serverPlugin = serverPluginDescription.getServerPlugin();
                    if (serverPlugin == null) continue;
                    serverPlugin.reset();
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().error(throwable);
                }
            }
        }
        SystemEventLog.ServerStopped.log(new Object[0]);
    }

    private void d() {
        SystemEventLog.ServerRestarted.log(new Object[0]);
        this.f = ServerPluginManagerState.INIT;
        if (this.b != null) {
            LogManager.getConfigLogger().info("Restart plugins");
            for (String string : this.b) {
                try {
                    ServerPluginDescription serverPluginDescription = this.a.get(string);
                    serverPluginDescription.getServerPlugin().restart();
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().error(throwable);
                    if (!(throwable instanceof Error)) continue;
                    this.f = ServerPluginManagerState.RESET;
                    throw (Error)throwable;
                }
            }
        }
    }

    public <T> void register(Class<T> interfaceClass, T instance) {
        String string;
        if (this.f == ServerPluginManagerState.INIT) {
            throw new IllegalStateException(this.f.toString() + ServerPluginManager.getDiagnostic());
        }
        if (interfaceClass == HelpProvider.class) {
            throw new IllegalArgumentException("Use registerHelp phase to register a HelpProvider");
        }
        List<?> list = this.e.get(interfaceClass);
        if (list == null) {
            list = new ArrayList();
            this.e.put(interfaceClass, list);
        } else if (NamedExtension.class.isAssignableFrom(interfaceClass)) {
            string = ((NamedExtension)instance).getExtensionName();
            if (list.stream().filter(object -> string.equals(((NamedExtension)object).getExtensionName())).findFirst().isPresent()) {
                throw new IllegalArgumentException("Cannot register duplicate name '" + string + "' for extension type " + String.valueOf(interfaceClass));
            }
        }
        list.add(instance);
        string = interfaceClass.getName();
        String string2 = instance.getClass().getName();
        LogManager.getConfigLogger().debug("  - " + string + ": " + string2);
    }

    @Nonnull
    public <T> List<T> get(@Nonnull Class<? super T> interfaceClass) {
        List<? super T> list;
        if (DEBUG && (list = DynamicExtensionManager.getInstance().a(interfaceClass)) != null) {
            throw new IllegalStateException(String.valueOf(interfaceClass) + " has also dynamic extensions. Use the DynamicExtensionManager.\n" + String.valueOf(list));
        }
        return this.a(interfaceClass);
    }

    @Nonnull
    <T> List<T> a(@Nonnull Class<? super T> clazz) {
        if (this.f != ServerPluginManagerState.INIT && this.f != ServerPluginManagerState.RESET) {
            throw new IllegalStateException(this.f.toString() + ServerPluginManager.getDiagnostic(), this.g);
        }
        return this.b(clazz);
    }

    @Nonnull
    <T> List<T> b(@Nonnull Class<? super T> clazz) {
        ArrayList arrayList;
        List<?> list = this.d.get(clazz);
        ArrayList<Object> arrayList2 = arrayList = list != null ? new ArrayList(list) : new ArrayList();
        if (LogManager.getConfigLogger().isDebug()) {
            LogManager.getConfigLogger().debug("get extensions for: " + clazz.getName() + " (" + arrayList.size() + ")");
        }
        return arrayList;
    }

    @Nonnull
    public <T> T getSingleInstance(Class<T> interfaceClass) throws IllegalStateException {
        if (this.f != ServerPluginManagerState.INIT && this.f != ServerPluginManagerState.RESET) {
            throw new IllegalStateException(this.f.toString() + ServerPluginManager.getDiagnostic(), this.g);
        }
        List<?> list = this.d.get(interfaceClass);
        if (list != null && list.size() == 1) {
            if (LogManager.getConfigLogger().isDebug()) {
                LogManager.getConfigLogger().debug("get extension for: " + interfaceClass.getName());
            }
            return (T)list.get(0);
        }
        StringBuilder stringBuilder = new StringBuilder("Instance count for " + String.valueOf(interfaceClass) + " is: ");
        if (list == null || list.size() == 0) {
            stringBuilder.append("0\nIt seems that a plugin is missing.");
        } else {
            stringBuilder.append(list.size());
            stringBuilder.append("\nIt seems that there is a duplicate plugin:");
            stringBuilder.append(ServerPluginManager.a(list));
        }
        throw new IllegalStateException(stringBuilder.toString());
    }

    private static <T> Object a(@Nullable List<T> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (T t : list) {
                stringBuilder.append("\n\t");
                stringBuilder.append(t.getClass());
                CodeSource codeSource = t.getClass().getProtectionDomain().getCodeSource();
                if (codeSource == null) continue;
                stringBuilder.append(" -> ");
                stringBuilder.append(codeSource.getLocation());
            }
        }
        return stringBuilder;
    }

    @Nonnull
    public <T extends NamedExtension> T getSingleInstanceByName(@Nonnull Class<? super T> interfaceClass, @Nullable String instanceKey, boolean useDefault) throws IllegalStateException {
        return ServerPluginManager.a(this.get(interfaceClass), interfaceClass, instanceKey, useDefault);
    }

    @Nonnull
    static <T extends NamedExtension> T a(List<T> list, @Nonnull Class<? super T> clazz, @Nullable String string, boolean bl) {
        for (NamedExtension namedExtension : list) {
            if (!namedExtension.getExtensionName().equals(string)) continue;
            return (T)namedExtension;
        }
        if (!bl) {
            throw new IllegalStateException("No extension with name '" + string + "' found for type '" + String.valueOf(clazz) + "'");
        }
        if (list.size() > 0) {
            NamedExtension namedExtension = (NamedExtension)list.get(0);
            if (LogManager.getConfigLogger().isDebug()) {
                LogManager.getConfigLogger().debug("No extension with name '" + string + "' found for type '" + String.valueOf(clazz) + "', returning default instance with name '" + namedExtension.getExtensionName() + "'");
            }
            return (T)namedExtension;
        }
        throw new IllegalStateException("There is no extension registered for type '" + String.valueOf(clazz) + "'");
    }

    @Nullable
    public <T> T getOptionalInstance(Class<T> interfaceClass) throws IllegalStateException {
        if (this.f != ServerPluginManagerState.INIT && this.f != ServerPluginManagerState.RESET) {
            throw new IllegalStateException(this.f.toString() + ServerPluginManager.getDiagnostic(), this.g);
        }
        List<?> list = this.d.get(interfaceClass);
        if (list != null) {
            if (list.size() == 1) {
                if (LogManager.getConfigLogger().isDebug()) {
                    LogManager.getConfigLogger().debug("get extension for: " + interfaceClass.getName());
                }
                return (T)list.get(0);
            }
            if (list.size() > 1) {
                throw new IllegalStateException("Instance count: " + list.size() + String.valueOf(ServerPluginManager.a(list)));
            }
        }
        LogManager.getConfigLogger().debug("got no extension for: " + interfaceClass.getName());
        return null;
    }

    private static String a(String string) {
        try {
            return System.getProperty(string);
        }
        catch (Throwable throwable) {
            return "<Unknown>";
        }
    }

    private static void a(Logger logger) {
        if (logger.isInfo()) {
            logger.info("Operating system name:               " + ServerPluginManager.a("os.name") + " " + ServerPluginManager.a("os.version") + " (" + ServerPluginManager.a("os.arch") + ")");
            logger.info("OS patch:                            " + ServerPluginManager.a("sun.os.patch.level"));
            logger.info("CPU:                                 " + ServerPluginManager.a("sun.cpu.isalist"));
            logger.info("Available Processors:                " + Runtime.getRuntime().availableProcessors());
            logger.info("Java Runtime Environment vendor:     " + ServerPluginManager.a("java.vendor"));
            logger.info("Java Runtime Environment version:    " + ServerPluginManager.a("java.version"));
            logger.info("Java Virtual Machine name:           " + ServerPluginManager.a("java.vm.name"));
            logger.info("Java Virtual Machine version:        " + ServerPluginManager.a("java.vm.version"));
            logger.info("Java Virtual Machine info:           " + ServerPluginManager.a("java.vm.info"));
            logger.info("Java class format version:           " + ServerPluginManager.a("java.class.version"));
            logger.info("Java class path:                     " + ServerPluginManager.a("java.class.path"));
            logger.info("Java library path:                   " + ServerPluginManager.a("java.library.path"));
            logger.info("Java default temp dir:               " + ServerPluginManager.a("java.io.tmpdir"));
            logger.info("Java extension directory:            " + ServerPluginManager.a("java.ext.dirs"));
            long l2 = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            logger.info("Maximum memory:                      " + l2 + " MB");
            logger.info("File encoding:                       " + ServerPluginManager.a("file.encoding"));
            logger.info("AWT headless property:               " + ServerPluginManager.a("java.awt.headless"));
            logger.info("User's account name:                 " + ServerPluginManager.a("user.name"));
            logger.info("User's region:                       " + ServerPluginManager.a("user.region"));
            logger.info("User's timezone:                     " + ServerPluginManager.a("user.timezone"));
            logger.info("Default locale:                      " + Locale.getDefault().toString());
            logger.info("User's home directory:               " + ServerPluginManager.a("user.home"));
            logger.info("User's current working directory:    " + ServerPluginManager.a("user.dir"));
            logger.info("Current time:                        " + String.valueOf(Calendar.getInstance().getTime()));
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            String string = ConfigurationManager.getScopeName(configuration.getScope());
            StringBuilder stringBuilder = new StringBuilder("Current configuration (scope/name):  ");
            stringBuilder.append(string);
            stringBuilder.append('/');
            stringBuilder.append(configuration.getName());
            if (string.equalsIgnoreCase("user")) {
                stringBuilder.append(" (User: ");
                stringBuilder.append(ServerPluginManager.a("user.name"));
                stringBuilder.append(" )");
            }
            logger.info(stringBuilder.toString());
            if (logger.isDebug()) {
                logger.debug(StringFunctions.listProperties(configuration.getProperties(), "global config"));
            }
        }
    }

    public boolean addExtractedPlugin(@Nonnull String className) {
        if (this.f != ServerPluginManagerState.PRE_INIT) {
            LogManager.getConfigLogger().warn("Plugin " + className + " cannot be added because plugin manager is already in: " + String.valueOf((Object)this.f));
            return false;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (clazz.getClassLoader() instanceof DependencyClassLoader) {
                LogManager.getConfigLogger().warn("Plugin " + className + " cannot be added because it was loaded by: " + String.valueOf(clazz.getClassLoader()));
                return false;
            }
            ServerPluginDescription serverPluginDescription = ServerPluginDescription.create((ServerPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), null);
            this.a.put(serverPluginDescription.getId(), serverPluginDescription);
            LogManager.getConfigLogger().debug("Extracted plugin was not added: " + className);
            return true;
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error("Plugin was not added: " + className);
            return false;
        }
    }

    @Deprecated
    public void init(@Nullable ServerPluginDescription core) {
        this.a((String)null, core);
    }

    public void init(ServerPluginDescription ... plugins) {
        this.a(null, plugins);
    }

    @Deprecated
    public void init(@Nullable String corePluginId) {
        this.a(corePluginId, (ServerPluginDescription[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private void a(String string, ServerPluginDescription ... serverPluginDescriptionArray) {
        ServerPluginDescription serverPluginDescription;
        Object object = this;
        synchronized (object) {
            switch (this.f) {
                case REGISTER: {
                    return;
                }
                case RESET: {
                    this.d();
                    return;
                }
                case INIT: {
                    throw new IllegalStateException(this.f.toString() + ServerPluginManager.getDiagnostic());
                }
                case PRE_INIT: {
                    this.f = ServerPluginManagerState.REGISTER;
                }
            }
        }
        Object object2 = object = serverPluginDescriptionArray != null && serverPluginDescriptionArray.length > 0 ? serverPluginDescriptionArray[0] : null;
        if (object != null && ((ServerPluginDescription)object).getServerPlugin() instanceof CoreServerPlugin) {
            this.m = string == null ? ((ServerPluginDescription)object).getId() : string;
            ((CoreServerPlugin)((ServerPluginDescription)object).getServerPlugin()).preInit((ServerPluginDescription)object);
        }
        Logger logger = LogManager.getConfigLogger();
        try {
            serverPluginDescription = ServerPluginDescription.create(new InetcoreServerPlugin(), this.getClass().getClassLoader());
        }
        catch (Exception exception) {
            throw (RuntimeException)ErrorCode.throwAny(exception);
        }
        if (object == null) {
            object = serverPluginDescription;
        }
        this.m = string == null ? ((ServerPluginDescription)object).getId() : string;
        ForkJoinPool.commonPool().execute(() -> AccessController.doPrivileged(() -> {
            NetworkFunctions.getCanonicalLocalHostName();
            return null;
        }));
        List<ResourceFile> list = this.getPluginDirs();
        ConfigurationManager.getInstance();
        logger = LogManager.getConfigLogger();
        ForkJoinPool.commonPool().execute(() -> ServerPluginManager.a(LogManager.getConfigLogger()));
        String string2 = ((ServerPluginDescription)object).getVersionString();
        logger.info("Starting initialization of application with ID '" + this.m + "' and version " + string2 + " from location " + String.valueOf(((ServerPluginDescription)object).getLocation()));
        ArrayList<File> arrayList = null;
        for (ResourceFile resourceFile : list) {
            for (Map.Entry<String, ServerPluginDescription> object3 : this.loadDirectory(resourceFile).entrySet()) {
                File file;
                ServerPluginDescription serverPluginDescription2 = this.a.put(object3.getKey(), object3.getValue());
                if (serverPluginDescription2 == null) continue;
                String string3 = object3.getValue().getDependencyVersion("inetcore");
                if (!StringFunctions.isEmpty(string3) && !serverPluginDescription.getVersionString().startsWith(string3)) {
                    this.a.put(object3.getKey(), serverPluginDescription2);
                    if (serverPluginDescription2.getVersion().isHigherThan(object3.getValue().getVersion())) {
                        file = new File(object3.getValue().getLocation().getAbsolutePath());
                        LogManager.getConfigLogger().info("Conflict with duplicate plugin. Delete older version: " + String.valueOf(object3.getValue().getVersion()) + " - " + String.valueOf(file));
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(file);
                        continue;
                    }
                    LogManager.getConfigLogger().error("Updated plugin '" + object3.getKey() + "' " + object3.getValue().getVersionString() + " is not compatible with the application version " + serverPluginDescription.getVersionString());
                    continue;
                }
                if (!serverPluginDescription2.getVersion().isHigherThan(object3.getValue().getVersion())) continue;
                this.a.put(object3.getKey(), serverPluginDescription2);
                file = new File(object3.getValue().getLocation().getAbsolutePath());
                LogManager.getConfigLogger().info("Conflict with duplicate plugin. Delete older version: " + String.valueOf(object3.getValue().getVersion()) + " - " + String.valueOf(file));
                if (arrayList == null) {
                    arrayList = new ArrayList<File>();
                }
                arrayList.add(file);
            }
        }
        if (serverPluginDescriptionArray != null) {
            for (ServerPluginDescription serverPluginDescription3 : serverPluginDescriptionArray) {
                if (serverPluginDescription3 == null) continue;
                this.a.put(serverPluginDescription3.getId(), serverPluginDescription3);
            }
        }
        this.a.put(serverPluginDescription.getId(), serverPluginDescription);
        this.b = new TreeSet<String>(this.a.keySet());
        ForkJoinPool.commonPool().execute(() -> SystemEventLog.ServerStarted.log(string2));
        this.f();
        this.a();
        this.a(true);
        this.b();
        this.c();
        this.h();
        this.e();
        Object object4 = this.b.iterator();
        while (object4.hasNext()) {
            block28: {
                String string4 = (String)object4.next();
                ServerPluginDescription serverPluginDescription3 = this.a.get(string4);
                logger.info("Registering extensions of '" + serverPluginDescription3.getId() + "' (" + serverPluginDescription3.getVersionString() + ")");
                try {
                    serverPluginDescription3.getServerPlugin().registerExtension(this);
                    this.e();
                }
                catch (Throwable throwable) {
                    this.a(serverPluginDescription3, throwable);
                    object4.remove();
                    if (!Objects.equals(string4, this.m)) break block28;
                    ErrorCode.throwAny(throwable);
                }
            }
            this.e.clear();
        }
        if (this.d.get(ApplicationDescription.class) == null) {
            this.register(ApplicationDescription.class, new InetApplicationDescription());
            this.e();
        }
        this.f = ServerPluginManagerState.INIT;
        this.a(null, false);
        DynamicExtensionManager.getInstance().a();
        object4 = new HashMap();
        for (String string5 : this.b) {
            ServerPluginDescription serverPluginDescription4 = this.a.get(string5);
            object4.put(string5, serverPluginDescription4);
        }
        this.a(new ArrayList<String>(this.b), (Map<String, ServerPluginDescription>)object4);
        this.q = true;
        this.a(null, true);
        VetoManager.getInstance();
        if (this.i) {
            ForkJoinPool.commonPool().execute(() -> AccessController.doPrivileged(() -> {
                ServerPluginManager.a(this.h, true, LogManager.getConfigLogger());
                return null;
            }));
        }
        if (arrayList != null && this.b.contains("setupwizard")) {
            ArrayList<File> arrayList2 = arrayList;
            ForkJoinPool.commonPool().execute(() -> AccessController.doPrivileged(() -> {
                for (File file : arrayList2) {
                    file.delete();
                }
                return null;
            }));
        }
        LogManager.getConfigLogger().info("Finished initialization of plugins. " + (String)(this.a.size() == 1 ? "1 plugin available." : this.a.size() + " plugins available."));
    }

    private void e() {
        for (Map.Entry<Class<?>, List<?>> entry : this.e.entrySet()) {
            List<?> list = this.d.get(entry.getKey());
            if (list == null) {
                this.d.put(entry.getKey(), entry.getValue());
                continue;
            }
            list.addAll((Collection)entry.getValue());
        }
        this.e.clear();
    }

    public String getCorePluginId() {
        return this.m;
    }

    public void setCorePluginId(String corePluginId) throws IllegalStateException {
        if (this.f == ServerPluginManagerState.INIT) {
            throw new IllegalStateException("setCorePluginId is only allowed before INIT state");
        }
        if (this.m != null && !Objects.equals(this.m, corePluginId)) {
            throw new IllegalStateException("setCorePluginId is already set");
        }
        this.m = corePluginId;
    }

    private void a(ServerPluginDescription serverPluginDescription, Throwable throwable) {
        Logger logger = LogManager.getConfigLogger();
        String string = serverPluginDescription.getId();
        logger.fatal("Plugin '" + string + "' (" + serverPluginDescription.getVersionString() + ") failed with " + throwable.toString() + ". Please remove the file" + (String)(serverPluginDescription.getLocation() != null ? " " + serverPluginDescription.getLocation().getAbsolutePath() : "") + ".");
        logger.fatal(throwable);
        if (this.c.get(string) == null) {
            this.c.put(string, throwable);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void a(List<String> list, Map<String, ServerPluginDescription> map) {
        if (list.size() == 0) {
            return;
        }
        for (String string : list) {
            ServerPluginDescription serverPluginDescription = map.remove(string);
            if (serverPluginDescription == null) continue;
            this.a(serverPluginDescription.getPreInitIds(), map);
            Logger logger = LogManager.getConfigLogger();
            try {
                logger.info("Initializing '" + string + "'");
                serverPluginDescription.getServerPlugin().init(this);
                this.a(string, true);
            }
            catch (Throwable throwable) {
                String string2 = "Init of plugin '" + serverPluginDescription.getId() + "' failed!";
                logger.fatal(string2);
                logger.fatal(throwable);
                this.c.put(serverPluginDescription.getId(), throwable);
                if (!(throwable instanceof Error)) continue;
                Error error = new Error(string2 + "\n" + throwable.toString(), throwable);
                this.g = error;
                throw error;
            }
        }
    }

    private void a(String string, boolean bl) {
        List<?> list = this.d.get(ServerPluginManagerListener.class);
        if (list != null) {
            PluginEvent pluginEvent = new PluginEvent(string);
            for (ServerPluginManagerListener serverPluginManagerListener : list) {
                try {
                    if (string == null) {
                        if (bl) {
                            serverPluginManagerListener.initFinished();
                            continue;
                        }
                        serverPluginManagerListener.initStarted();
                        continue;
                    }
                    serverPluginManagerListener.pluginInitialized(pluginEvent);
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().error("Error in ServerPluginManagerListener:");
                    LogManager.getConfigLogger().error(throwable);
                }
            }
        }
    }

    private void f() {
        if (this.a != null) {
            Logger logger = LogManager.getConfigLogger();
            logger.info("Checking init constraints plugins");
            for (ServerPluginDescription serverPluginDescription : this.a.values()) {
                for (String string : serverPluginDescription.getPreInitIds()) {
                    if (this.a.containsKey(string)) continue;
                    logger.warn("Plugin requires to init '" + string + "' first, but the referenced plugin is not registered.");
                }
            }
            logger.info("Checking init constraints finished");
        }
    }

    public File getTempDir() {
        if (this.h == null) {
            this.h = this.b(LogManager.getConfigLogger());
        }
        return this.h;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private File b(@Nonnull Logger logger) {
        File file = null;
        try {
            String string = System.getProperty("java.io.tmpdir");
            String string2 = null;
            try {
                string2 = ProcessHandle.current().info().user().get();
                string2 = string2.substring(string2.indexOf(92) + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) {
                string2 = System.getProperty("user.name");
            }
            string2 = string2.replace(" ", "");
            file = new File(new File(string), "com.inet.plugin-" + string2);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (file != null) {
            file = ServerPluginManager.a(file, logger, false);
        }
        if (file != null) {
            this.i = true;
        } else {
            this.i = false;
            file = ServerPluginManager.a(new File(System.getProperty("java.io.tmpdir")), logger, true);
            if (file == null) {
                file = ServerPluginManager.a(new File(new File(System.getProperty("user.home")), "com.inet.plugin"), logger, true);
            }
            if (file == null) {
                file = ServerPluginManager.a(new File(new File("."), "com.inet.plugin"), logger, true);
            }
            if (file == null) {
                logger.fatal("No temp directory for extracting jar cache was found.");
                LogManager.stopSpooler();
                System.exit(2);
                return null;
            }
        }
        logger.info("Using temp directory for extracting jar cache: " + file.getAbsolutePath());
        return file;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private static File a(File file, Logger logger, boolean bl) {
        try {
            file.mkdirs();
            File file2 = File.createTempFile("inetjarcache", ".txt", file);
            File file3 = file2.getParentFile();
            file2.delete();
            if (file3 != null) {
                logger.info("Using temp directory for extracting jar cache: " + file3.getAbsolutePath());
                if (bl) {
                    ServerPluginManager.a(file3, true, logger);
                }
                return file3;
            }
            logger.fatal("Temp directory for extracting jar cache not found.");
        }
        catch (IOException iOException) {
            logger.fatal("There are no write permissions to the directory: " + String.valueOf(file));
            logger.fatal(iOException);
        }
        return null;
    }

    protected Map<String, ServerPluginDescription> readPluginsFromDirectory(ResourceFile[] archives) {
        HashMap<String, ServerPluginDescription> hashMap = new HashMap<String, ServerPluginDescription>();
        File file = this.getTempDir();
        Arrays.sort(archives, new Comparator<ResourceFile>(){

            public int a(ResourceFile resourceFile, ResourceFile resourceFile2) {
                return resourceFile.getName().compareToIgnoreCase(resourceFile2.getName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((ResourceFile)object, (ResourceFile)object2);
            }
        });
        Logger logger = LogManager.getConfigLogger();
        for (ResourceFile resourceFile : archives) {
            ServerPluginDescription serverPluginDescription;
            ServerPluginDescription serverPluginDescription2;
            if (!resourceFile.getName().toLowerCase().endsWith(".zip") || (serverPluginDescription2 = ServerPluginDescription.create(resourceFile, file, logger)) == null || (serverPluginDescription = hashMap.put(serverPluginDescription2.getId(), serverPluginDescription2)) == null) continue;
            logger.error("Duplicate plugin ID: " + serverPluginDescription2.getId() + " [" + serverPluginDescription.getVersionString() + "," + serverPluginDescription2.getVersionString() + "]");
            ClassLoader classLoader = serverPluginDescription.getClassLoader();
            ClassLoader classLoader2 = serverPluginDescription2.getClassLoader();
            if (classLoader instanceof URLClassLoader && classLoader2 instanceof URLClassLoader) {
                logger.error("\t" + String.valueOf(((URLClassLoader)classLoader).getURLs()[0]));
                logger.error("\t" + String.valueOf(((URLClassLoader)classLoader2).getURLs()[0]));
            }
            if (!serverPluginDescription.getVersion().isHigherThan(serverPluginDescription2.getVersion())) continue;
            hashMap.put(serverPluginDescription2.getId(), serverPluginDescription);
        }
        return hashMap;
    }

    private static void a(File file, boolean bl, @Nonnull Logger logger) {
        if (file == null || !file.canRead()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname == null) {
                    return false;
                }
                if (pathname.isDirectory()) {
                    return false;
                }
                return pathname.getName().toLowerCase().endsWith(".jar");
            }
        });
        long l2 = System.currentTimeMillis() - 604800000L;
        if (fileArray != null && fileArray.length > 0) {
            logger.info("Clearing old jar cache.");
            for (File file2 : fileArray) {
                try {
                    if (bl && file2.lastModified() >= l2) continue;
                    FileChannel fileChannel = new RandomAccessFile(file2, "rw").getChannel();
                    FileLock fileLock = null;
                    try {
                        fileLock = fileChannel.tryLock();
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {
                        // empty catch block
                    }
                    fileChannel.close();
                    if (fileLock == null) continue;
                    file2.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected Map<String, ServerPluginDescription> loadDirectory(ResourceFile pluginsDir) {
        Logger logger = LogManager.getConfigLogger();
        logger.info("Searching for plugins in folder '" + pluginsDir.getPath() + "'");
        if (!pluginsDir.isDirectory()) {
            logger.debug("plugin directory not found! " + pluginsDir.getAbsolutePath());
            return new HashMap<String, ServerPluginDescription>();
        }
        ResourceFile[] resourceFileArray = pluginsDir.listFiles();
        return this.readPluginsFromDirectory(resourceFileArray);
    }

    void a() {
        Object object;
        Map map;
        Logger logger = LogManager.getConfigLogger();
        if (this.o != null) {
            map = this.b.iterator();
            while (map.hasNext()) {
                object = (String)map.next();
                if (Objects.equals(object, this.m) || this.o.accept(this.a.get(object))) continue;
                map.remove();
                logger.info("Plugin '" + (String)object + "' can not be used due to being filtered.");
                this.c.put((String)object, (Object)PluginLoadFailCause.FILTER);
            }
        }
        try {
            logger.info("Checking activated plugins");
            map = this.p;
            if (map != null) {
                this.p = null;
            } else {
                try {
                    object = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PLUGINS_ACTIVATED.getKey(), ConfigKey.PLUGINS_ACTIVATED.getDefault());
                    map = new Json().fromJson((String)object, Map.class);
                }
                catch (RuntimeException runtimeException) {
                    map = new HashMap();
                    LogManager.getConfigLogger().error(runtimeException);
                }
            }
            object = this.b.iterator();
            while (object.hasNext()) {
                Boolean bl;
                String string = (String)object.next();
                List<String> list = this.a.get(string).getFlags();
                Boolean bl2 = bl = Objects.equals(string, this.m) ? Boolean.TRUE : (Boolean)map.get(string);
                boolean bl3 = bl == null ? list.contains("core") || !list.contains("optional") : bl;
                if (bl3) continue;
                logger.info("Plugin '" + string + "' can not be used due to being deactivated.");
                object.remove();
                this.c.put(string, (Object)PluginLoadFailCause.DISABLED);
            }
            logger.info("Activated check finished");
        }
        catch (Throwable throwable) {
            logger.error(throwable);
        }
    }

    void a(boolean bl) {
        Logger logger = LogManager.getConfigLogger();
        boolean bl2 = false;
        logger.info("Checking plugin dependencies");
        do {
            bl2 = false;
            Iterator<String> iterator = this.b.iterator();
            block1: while (iterator.hasNext()) {
                String string = iterator.next();
                if (Objects.equals(string, this.m) && (Objects.equals(string, "designer") || ConfigurationManager.isRecoveryMode())) continue;
                ServerPluginDescription serverPluginDescription = this.a.get(string);
                Set<String> set = serverPluginDescription.getDependencyIds();
                for (String string2 : set) {
                    Object object;
                    Object object2;
                    if (!this.b.contains(string2)) {
                        this.c.put(string, (Object)PluginLoadFailCause.DEPENDENCY);
                        if (bl && Objects.equals(string, this.m) && !(serverPluginDescription.getClassLoader() instanceof DependencyClassLoader)) continue block1;
                        object2 = "Plugin '" + serverPluginDescription.getId() + "' can not be used due to missing dependency: '" + string2 + "'!";
                        logger.info(object2);
                        iterator.remove();
                        bl2 = true;
                        if (!bl || !Objects.equals(string, this.m)) continue block1;
                        object = new IllegalStateException((String)object2);
                        logger.fatal(object);
                        throw object;
                    }
                    object2 = serverPluginDescription.getDependencyVersion(string2);
                    if (StringFunctions.isEmpty((String)object2) || ((ServerPluginDescription)(object = this.a.get(string2))).getVersionString().startsWith((String)object2)) continue;
                    logger.info("Plugin '" + serverPluginDescription.getId() + "' can not be used because the needed dependency version: '" + string2 + "' " + (String)object2 + "!");
                    iterator.remove();
                    bl2 = true;
                    this.c.put(string, (Object)PluginLoadFailCause.VERSION);
                    continue block1;
                }
            }
        } while (bl2);
        logger.info("Dependencies check finished");
    }

    private Set<String> g() {
        return ConfigurationManager.isHelpCenterMode() ? this.a.keySet() : this.b;
    }

    void b() {
        for (String string : this.g()) {
            ServerPluginDescription serverPluginDescription = this.a.get(string);
            this.a(serverPluginDescription, serverPluginDescription.getDependencyIds(), false);
            this.a(serverPluginDescription, serverPluginDescription.getOptionalDependencyIds(), true);
        }
    }

    private void a(ServerPluginDescription serverPluginDescription, Collection<String> collection, boolean bl) {
        for (String string : collection) {
            ServerPluginDescription serverPluginDescription2;
            ServerPluginDescription serverPluginDescription3 = serverPluginDescription2 = this.b.contains(string) || ConfigurationManager.isHelpCenterMode() ? this.a.get(string) : null;
            if (serverPluginDescription2 == null) {
                if (bl) continue;
                LogManager.getConfigLogger().warn("Plugin '" + serverPluginDescription.getId() + "' required dependency is missing: " + string);
                continue;
            }
            String[] stringArray = serverPluginDescription2.getPackages();
            if (stringArray == null || stringArray.length == 0) {
                if ("inetcore".equals(string)) continue;
                LogManager.getConfigLogger().warn("Plugin '" + serverPluginDescription.getId() + "' depends on '" + string + "' which provides no packages");
                continue;
            }
            for (String string2 : stringArray) {
                if (string2.trim().length() <= 0) continue;
                serverPluginDescription.addDependency(string2, serverPluginDescription2.getClassLoader());
            }
        }
    }

    void c() {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        Logger logger = LogManager.getConfigLogger();
        Set<String> set = this.g();
        new HashSet<String>(set).parallelStream().forEach(string -> {
            ServerPluginDescription serverPluginDescription = this.a.get(string);
            logger.info("Load plugin '" + serverPluginDescription.getId() + "' (" + serverPluginDescription.getVersionString() + ")");
            try {
                serverPluginDescription.loadServerPlugin();
            }
            catch (Throwable throwable) {
                logger.info("Plugin '" + serverPluginDescription.getId() + "' (" + serverPluginDescription.getVersionString() + ") loading failed.");
                logger.error(throwable);
                this.b.remove(string);
                atomicBoolean.set(true);
                this.c.put((String)string, throwable);
            }
        });
        if (atomicBoolean.get()) {
            this.a(true);
        }
    }

    private void h() {
        Object object;
        Object object2;
        Object object3;
        if (!this.isPluginLoaded("help")) {
            return;
        }
        LogManager.getConfigLogger().info("Registering help of plugins");
        Set<String> set = this.g();
        HelpProviderContainer helpProviderContainer = new HelpProviderContainer(set, this.d.get(HelpProvider.class));
        Object object4 = set.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            object2 = this.a.get(object3);
            try {
                object = ((ServerPluginDescription)object2).getServerPlugin();
                if (object == null) continue;
                object.registerHelp(helpProviderContainer);
            }
            catch (Throwable throwable) {
                this.a((ServerPluginDescription)object2, throwable);
                object4.remove();
            }
        }
        object4 = LogManager.getLogger("Help");
        if (object4.isDebug()) {
            object3 = new ArrayList<HelpProvider>(helpProviderContainer.a());
            object3.sort(Comparator.comparingInt(HelpProvider::getPriority));
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (HelpProvider)object2.next();
                LogManager.getLogger("Help").debug("helpProvider = " + String.valueOf(object.getHelpSet()) + "\tPrio => " + object.getPriority());
            }
        }
        this.d.put(HelpProvider.class, helpProviderContainer.a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceFile getPluginFile(String id, String path) throws IOException {
        ServerPluginDescription serverPluginDescription = this.a.get(id);
        if (serverPluginDescription == null) {
            return null;
        }
        ResourceFile resourceFile = serverPluginDescription.getLocation();
        if (resourceFile == null) {
            return null;
        }
        ArchiveFile archiveFile = resourceFile.createArchiveFile();
        ZipEntry zipEntry = null;
        try {
            Object object;
            long l2;
            long l3;
            InputStream inputStream;
            zipEntry = archiveFile.getEntry(path);
            if (zipEntry == null) {
                if (path.toUpperCase().endsWith(".CLASS")) {
                    ResourceFile resourceFile2 = null;
                    return resourceFile2;
                }
                inputStream = serverPluginDescription.getClassLoader().getResourceAsStream(path);
                if (inputStream == null) {
                    ResourceFile resourceFile3 = null;
                    return resourceFile3;
                }
                l3 = resourceFile.lastModified();
                l2 = inputStream.available();
            } else {
                object = archiveFile.getInputStream(zipEntry);
                inputStream = new InputStream((InputStream)object, archiveFile){
                    final /* synthetic */ InputStream a;
                    final /* synthetic */ ArchiveFile b;
                    {
                        this.a = inputStream;
                        this.b = archiveFile;
                    }

                    @Override
                    public int read(byte[] b2) throws IOException {
                        return this.a.read(b2);
                    }

                    @Override
                    public synchronized void reset() throws IOException {
                        this.a.reset();
                    }

                    @Override
                    public synchronized void mark(int readlimit) {
                        this.a.mark(readlimit);
                    }

                    @Override
                    public boolean markSupported() {
                        return this.a.markSupported();
                    }

                    @Override
                    public long skip(long n2) throws IOException {
                        return this.a.skip(n2);
                    }

                    @Override
                    public int available() throws IOException {
                        return this.a.available();
                    }

                    @Override
                    public void close() throws IOException {
                        this.a.close();
                        this.b.close();
                    }

                    protected void finalize() throws Throwable {
                        this.close();
                    }

                    @Override
                    public int read(byte[] b2, int off, int len) throws IOException {
                        return this.a.read(b2, off, len);
                    }

                    @Override
                    public int read() throws IOException {
                        return this.a.read();
                    }
                };
                l3 = zipEntry.getTime();
                l2 = zipEntry.getSize();
            }
            object = new VirtualFile(path, l3, inputStream, l2);
            return object;
        }
        finally {
            if (zipEntry == null) {
                archiveFile.close();
            }
        }
    }

    public boolean isPluginLoaded(String id) {
        return this.b.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIfPluginLoaded(String id, Supplier<Executable> pluginRegisterSupplier) {
        if (this.isPluginLoaded(id)) {
            ClassLoader classLoader = ThreadUtils.getCallerClass(1).getClassLoader();
            if (classLoader instanceof DependencyClassLoader || classLoader == this.getPluginDescription(id).getServerPlugin().getClass().getClassLoader()) {
                try {
                    pluginRegisterSupplier.get().execute();
                }
                catch (Throwable throwable) {
                    String string;
                    Object object;
                    if (classLoader instanceof DependencyClassLoader) {
                        object = (DependencyClassLoader)classLoader;
                        v0 = ((DependencyClassLoader)object).getPluginId();
                    } else {
                        v0 = string = null;
                    }
                    if (this.f == ServerPluginManagerState.REGISTER && !Objects.equals(this.m, string)) {
                        throw throwable;
                    }
                    LogManager.getConfigLogger().fatal(throwable);
                    MaintenanceMode.start();
                    if (!(this.c.get(id) instanceof Throwable)) {
                        this.c.put(id, throwable);
                    }
                    if (string != null && !(this.c.get(string) instanceof Throwable)) {
                        this.c.put(string, throwable);
                    }
                    object = "fatal.error.runIfPluginLoaded";
                    Class<ServerPluginManager> clazz = ServerPluginManager.class;
                    synchronized (ServerPluginManager.class) {
                        try {
                            GlobalBannerManager.getInstance().unregisterGlobalBanner((String)object);
                            GlobalBannerManager.getInstance().registerGlobalBanner(new GlobalBanner(){
                                final /* synthetic */ String a;
                                final /* synthetic */ Throwable b;
                                {
                                    this.a = string;
                                    this.b = throwable;
                                }

                                @Override
                                @Nonnull
                                public String getExtensionName() {
                                    return this.a;
                                }

                                @Override
                                public boolean isVisibleInApp(@Nonnull String appPath) {
                                    return true;
                                }

                                @Override
                                @Nullable
                                public GlobalBanner.BannerLink getLink() {
                                    return null;
                                }

                                @Override
                                public boolean isAvailableForUser(@Nullable GUID userId) {
                                    return true;
                                }

                                @Override
                                @Nonnull
                                public String getText() {
                                    return VetoManager.MSG.getMsg("ServerInMaintenance", StringFunctions.getUserFriendlyErrorMessage(this.b));
                                }

                                @Override
                                @Nonnull
                                public GlobalBanner.BannerType getBannerType() {
                                    return GlobalBanner.BannerType.danger;
                                }
                            });
                        }
                        catch (Throwable throwable2) {
                            LogManager.getConfigLogger().fatal(throwable2);
                        }
                    }
                }
            } else {
                LogManager.getConfigLogger().error("The calling plugin is not loaded from a DependencyClassLoader: " + String.valueOf(classLoader) + ". The dependency to the plugin " + id + " cannot be registered. You cannot mix plugin mode and library mode. see https://faq.inetsoftware.de/t/how-to-use-i-net-clear-reports-as-library-in-an-application-server/267");
            }
        }
    }

    public Object getPluginLoadError(String id) {
        return this.c.get(id);
    }

    public void setPluginLoadError(String id, Throwable th) {
        this.c.put(id, th);
    }

    public String[] getLoadedPlugins() {
        return this.b.toArray(new String[this.b.size()]);
    }

    public String[] getAvailablePlugins() {
        return this.a.keySet().toArray(new String[this.a.size()]);
    }

    public void setPluginDir(String pluginDir) {
        this.setPluginDir(new FileResourceFile(pluginDir));
    }

    public void setPluginDir(ResourceFile pluginDir) {
        if (this.f == ServerPluginManagerState.INIT) {
            throw new IllegalStateException("setPluginDir is only allowed before INIT state");
        }
        if (this.j != null && pluginDir != null) {
            return;
        }
        this.j = pluginDir;
    }

    public ResourceFile getPluginDir() {
        ResourceFile resourceFile = this.j;
        if (resourceFile == null) {
            resourceFile = BaseLocator.getBaseDirectory().createChild(PLUGINS);
        }
        return resourceFile;
    }

    @Nonnull
    public List<ResourceFile> getPluginDirs() {
        List<ResourceFile> list = this.k;
        if (list != null) {
            return list;
        }
        list = new ArrayList<ResourceFile>();
        Persistence persistence = this.m != null ? Persistence.getInstance() : null;
        list.add(this.getPluginDir());
        if (persistence != null) {
            ResourceFile resourceFile = persistence instanceof FilePersistence ? new FileResourceFile(((FilePersistence)Persistence.getRecoveryEnabledInstance()).getPersistenceFolder().resolve(PLUGINS).toFile()) : new PersistenceResourceFile(persistence.resolve(PLUGINS));
            list.add(resourceFile);
        }
        if (this.m != null) {
            this.k = list = Collections.unmodifiableList(list);
        }
        return list;
    }

    @Nonnull
    public ResourceFile getTranslationsDir() {
        if (this.l != null) {
            return this.l;
        }
        List<ResourceFile> list = this.getPluginDirs();
        this.l = list.get(list.size() - 1).createChild("translation");
        return this.l;
    }

    public void setPluginFilter(PluginFilter filter) {
        this.o = filter;
    }

    @Nullable
    public PluginFilter getPluginFilter() {
        return this.o;
    }

    public void setActived(Map<String, Boolean> activated) {
        this.p = activated;
    }

    public ServerPluginManagerState getState() {
        return this.f;
    }

    public boolean isInitFinish() {
        return this.q;
    }

    public void waitOnInitState(int seconds) {
        for (int i2 = 0; i2 < seconds; ++i2) {
            if (this.f == ServerPluginManagerState.INIT) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                ErrorCode.throwAny(interruptedException);
            }
        }
    }

    public Throwable getThrowable() {
        return this.g;
    }

    public ServerPluginDescription getPluginDescription(String id) {
        return this.a.get(id);
    }

    @Nonnull
    public Properties getStartProperties() {
        if (this.n == null) {
            this.n = new Properties();
        }
        return this.n;
    }

    public void uninstall(ServerPluginDescription core, boolean isFullUninstall) {
        if (this.f != ServerPluginManagerState.PRE_INIT) {
            throw new IllegalStateException("Uninstall tasks of available plugins can be executed only when ServerPluginManager's state is PRE_INIT.");
        }
        Logger logger = LogManager.getConfigLogger();
        ResourceFile resourceFile = BaseLocator.getBaseDirectory().createChild(PLUGINS);
        this.a = this.loadDirectory(resourceFile);
        try {
            ServerPluginDescription serverPluginDescription = ServerPluginDescription.create(new InetcoreServerPlugin(), this.getClass().getClassLoader());
            this.a.put(serverPluginDescription.getId(), serverPluginDescription);
        }
        catch (Exception exception) {
            throw (RuntimeException)ErrorCode.throwAny(exception);
        }
        if (core != null) {
            this.m = core.getId();
            this.a.put(core.getId(), core);
        }
        this.b = new TreeSet<String>(this.a.keySet());
        this.a(false);
        this.b();
        logger.info("Starting execution of uninstall tasks of available plugins.");
        for (String string : this.b) {
            ServerPluginDescription serverPluginDescription = this.a.get(string);
            try {
                serverPluginDescription.loadServerPlugin();
            }
            catch (Throwable throwable) {
                logger.error("Error occurred during loading plugin " + string + ". Execution of uninstall tasks for that plugin will be skipped.");
                logger.error(throwable);
                continue;
            }
            try {
                logger.info("Executing uninstall task of '" + serverPluginDescription.getId() + "' (" + serverPluginDescription.getVersionString() + ").");
                serverPluginDescription.getServerPlugin().uninstall(isFullUninstall);
            }
            catch (RuntimeException runtimeException) {
                logger.error("Error occurred during uninstall of plugin " + string);
                logger.error(runtimeException);
            }
        }
        logger.info("Finished execution of uninstall tasks of available plugins.");
    }

    private ResourceFile a(ResourceFile resourceFile, @Nonnull Logger logger) {
        ResourceFile resourceFile2;
        Object object;
        if (resourceFile == null) {
            return null;
        }
        if (Persistence.isFilePersistence()) {
            object = System.getProperty("AppDataPath");
            if (object == null) {
                return resourceFile;
            }
            resourceFile2 = new FileResourceFile((String)object).createChild(PLUGINS).createChild(resourceFile.getName());
        } else {
            if (System.getProperty("restart.exitcode") == null) {
                return resourceFile;
            }
            resourceFile2 = new PersistenceResourceFile(Persistence.getInstance().resolve(PLUGINS).resolve(resourceFile.getName()));
        }
        if (!resourceFile2.exists()) {
            return resourceFile;
        }
        object = this.b(logger);
        ServerPluginDescription serverPluginDescription = ServerPluginDescription.create(resourceFile, (File)object, logger);
        ServerPluginDescription serverPluginDescription2 = ServerPluginDescription.create(resourceFile2, (File)object, logger);
        if (serverPluginDescription.getVersion().isHigherThan(serverPluginDescription2.getVersion())) {
            return resourceFile;
        }
        return resourceFile2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private ResourceFile a(@Nullable String object, @Nonnull Logger logger) {
        void var4_9;
        void var4_6;
        ResourceFile[] resourceFileArray;
        if (this.j == null) {
            this.j = BaseLocator.getBaseDirectoryWithoutInitConfig().createChild(PLUGINS);
        }
        if ((resourceFileArray = this.j.listFiles()) == null) {
            return null;
        }
        if (object != null) {
            object = ((String)object).toLowerCase() + "[-.0-9]*.zip";
            for (ResourceFile resourceFile : resourceFileArray) {
                if (!resourceFile.getName().toLowerCase().matches((String)object)) continue;
                return this.a(resourceFile, logger);
            }
        }
        Object var4_5 = null;
        ResourceFile resourceFile = null;
        for (ResourceFile resourceFile2 : resourceFileArray) {
            String string = resourceFile2.getName().toLowerCase();
            if (string.matches("pdfc[-.0-9]*.zip") || string.matches("helpdesk[-.0-9]*.zip")) {
                return this.a(resourceFile2, logger);
            }
            if (string.matches("reporting[-.0-9]*.zip")) {
                ResourceFile resourceFile3 = resourceFile2;
                continue;
            }
            if (!string.matches("cowork[-.0-9]*.zip")) continue;
            resourceFile = resourceFile2;
        }
        if (var4_6 == null && resourceFile != null) {
            ResourceFile resourceFile4 = resourceFile;
        }
        return this.a((ResourceFile)var4_9, logger);
    }

    @Nullable
    protected ServerPluginDescription findCoreServerPluginDescriptionWithoutLoadingForServerStart(@Nullable String coreID, @Nonnull Logger logger) throws Exception {
        if ("inetcore".equals(coreID)) {
            return ServerPluginDescription.create(new InetcoreServerPlugin(), null, null, this.getClass().getClassLoader(), logger);
        }
        File file = this.b(logger);
        ResourceFile resourceFile = this.a(coreID, logger);
        if (resourceFile != null) {
            return ServerPluginDescription.create(resourceFile, file, logger);
        }
        return null;
    }

    @Nullable
    public ServerPluginDescription loadCoreServerPluginDescriptionForServerStart(@Nullable String coreID) throws Exception {
        if (this.f != ServerPluginManagerState.PRE_INIT) {
            throw new IllegalStateException();
        }
        StartupLogger startupLogger = new StartupLogger();
        ServerPluginDescription serverPluginDescription = this.findCoreServerPluginDescriptionWithoutLoadingForServerStart(coreID, startupLogger);
        if (serverPluginDescription != null) {
            serverPluginDescription.b(startupLogger);
            serverPluginDescription.loadServerPlugin();
            return serverPluginDescription;
        }
        return null;
    }

    @Nonnull
    public static String getDiagnostic() {
        try {
            try {
                ThreadUtils.threadDump(LogManager.getLogStream());
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            Logger logger = LogManager.getConfigLogger();
            logger.setLogLevel(4);
            ServerPluginManager.a(logger);
            Thread.sleep(1L);
            StringBuilder stringBuilder = new StringBuilder("\n\tDiagnostic details for support:");
            stringBuilder.append("\n\t\tPlease send the completely log output as text. Enable the debug log level via recovery tool to receive more details.");
            stringBuilder.append("\n\t\tCore version: 25.10.259");
            stringBuilder.append("\n\t\tCommand line: " + String.valueOf(ManagementFactory.getRuntimeMXBean().getInputArguments()));
            if (r != null) {
                stringBuilder.append("\n\t\tPlugin Directory: " + String.valueOf(r.getPluginDir()));
                stringBuilder.append("\n\t\tAppDataPath: " + System.getProperty("AppDataPath"));
                stringBuilder.append("\n\t\tPlugin Directories: " + String.valueOf(r.getPluginDirs()));
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return "\n\tDiagnostic details: " + String.valueOf(throwable);
        }
    }

    static {
        boolean bl;
        DEBUG = DebugUtils.DEBUG;
        ShutdownManager.add(new ShutdownFinalizer(){

            @Override
            public void onShutdown() {
                ServerPluginManager serverPluginManager = r;
                if (serverPluginManager != null) {
                    serverPluginManager.reset();
                }
            }

            @Override
            public int order() {
                return -1000000;
            }
        });
        try {
            Class.forName("jakarta.servlet.http.HttpSessionListener");
            Class.forName("jakarta.websocket.DeploymentException");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        IS_SERVLET_API = bl;
        ThreadUtils.getCpuTime();
    }

    @PublicApi
    public static final class ServerPluginManagerState
    extends Enum<ServerPluginManagerState> {
        public static final /* enum */ ServerPluginManagerState PRE_INIT = new ServerPluginManagerState();
        public static final /* enum */ ServerPluginManagerState REGISTER = new ServerPluginManagerState();
        public static final /* enum */ ServerPluginManagerState INIT = new ServerPluginManagerState();
        public static final /* enum */ ServerPluginManagerState RESET = new ServerPluginManagerState();
        private static final /* synthetic */ ServerPluginManagerState[] a;

        public static ServerPluginManagerState[] values() {
            return (ServerPluginManagerState[])a.clone();
        }

        public static ServerPluginManagerState valueOf(String name) {
            return Enum.valueOf(ServerPluginManagerState.class, name);
        }

        private static /* synthetic */ ServerPluginManagerState[] a() {
            return new ServerPluginManagerState[]{PRE_INIT, REGISTER, INIT, RESET};
        }

        static {
            a = ServerPluginManagerState.a();
        }
    }

    @PublicApi
    public static final class PluginLoadFailCause
    extends Enum<PluginLoadFailCause> {
        public static final /* enum */ PluginLoadFailCause FILTER = new PluginLoadFailCause();
        public static final /* enum */ PluginLoadFailCause DISABLED = new PluginLoadFailCause();
        public static final /* enum */ PluginLoadFailCause VERSION = new PluginLoadFailCause();
        public static final /* enum */ PluginLoadFailCause DEPENDENCY = new PluginLoadFailCause();
        private static final /* synthetic */ PluginLoadFailCause[] a;

        public static PluginLoadFailCause[] values() {
            return (PluginLoadFailCause[])a.clone();
        }

        public static PluginLoadFailCause valueOf(String name) {
            return Enum.valueOf(PluginLoadFailCause.class, name);
        }

        private static /* synthetic */ PluginLoadFailCause[] a() {
            return new PluginLoadFailCause[]{FILTER, DISABLED, VERSION, DEPENDENCY};
        }

        static {
            a = PluginLoadFailCause.a();
        }
    }
}

