/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.cache;

import com.inet.font.FontUtils;
import com.inet.font.cache.FontPathMapping;
import com.inet.font.truetype.FontFactoriesCache;
import com.inet.font.type1.SubFontOptions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.annotation.SuppressFBWarnings;

public class FontPoolData {
    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Admin config the file")
    public static final void locateFontFilesAndCreateFontFactories() {
        int n2 = 0;
        long l2 = 0L;
        FontPathMapping.a();
        FontFactoriesCache.init();
        ArrayList<String> arrayList = FontPoolData.a();
        Logger logger = LogManager.getConfigLogger();
        for (String string : arrayList) {
            try {
                File file;
                if (logger.isDebug()) {
                    logger.debug("Load ttf fonts from font path: '" + string + "'");
                }
                if (!(file = new File(string)).isDirectory()) {
                    logger.error("No such directory: '" + string + "'");
                    continue;
                }
                String[] stringArray = null;
                try {
                    stringArray = file.list();
                }
                catch (SecurityException securityException) {
                    logger.error("Font path '" + string + "' can't be accessed: " + securityException.getMessage());
                    continue;
                }
                if (stringArray == null) {
                    logger.error("I/O Error by reading font path '" + string + "'");
                    continue;
                }
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string2 = stringArray[i2].toLowerCase();
                    if (string2.endsWith(".ttf") || string2.endsWith(".ttc") || string2.endsWith(".tte") || SubFontOptions.USE_OTF_FONTS && string2.endsWith(".otf")) {
                        void object;
                        if (!object.endsWith(" \\") && !object.endsWith("/")) {
                            String string3 = (String)object + File.separator;
                        }
                        String string4 = (String)object + stringArray[i2];
                        l2 += (long)FontFactoriesCache.registerFontPath(string4, n2, true);
                        ++n2;
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    if (logger.isDebug()) {
                        logger.debug("Font loading interrupted");
                    }
                    return;
                }
            }
            catch (Exception exception) {
                logger.error("Exception while loading fonts from font path: " + string);
                logger.error(exception);
            }
        }
        logger.info("Count of installed fonts : " + n2);
        logger.debug("Count of alias font names registered: " + l2);
    }

    private static ArrayList<String> a() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = FontUtils.getSettings().getFontPath();
        if (StringFunctions.isEmpty(string)) {
            LogManager.getConfigLogger().info("Font path for embedded fonts is empty");
            return arrayList;
        }
        string = string.replace('\\', '/');
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        block0: while (stringTokenizer.hasMoreElements()) {
            Object object = stringTokenizer.nextToken();
            if (((String)(object = ((String)object).trim())).length() == 0) continue;
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            for (String string2 : arrayList) {
                if (!string2.equalsIgnoreCase((String)object)) continue;
                continue block0;
            }
            arrayList.add((String)object);
        }
        return arrayList;
    }
}

