/*
 * Decompiled with CFR 0.152.
 */
package com.inet.error;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.error.HasErrorCode;
import com.inet.http.error.HttpFailedException;
import com.inet.http.servlet.ClientLocale;
import com.inet.permissions.url.URLPermissionChecker;
import jakarta.servlet.http.HttpServletRequest;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ErrorCodeHelper {
    static final Map<Integer, ErrorCode> a = new ConcurrentHashMap<Integer, ErrorCode>();
    private static int[] b = new int[]{BaseErrorCode.forbidden.getErrorCodeNumber(), BaseErrorCode.InvalidOrigin.getErrorCodeNumber()};
    private static int[] c = new int[]{BaseErrorCode.UserLoginRequired.getErrorCodeNumber(), BaseErrorCode.UserNotLoggedIn.getErrorCodeNumber()};
    private static int[] d = new int[]{BaseErrorCode.forbidden.getErrorCodeNumber(), BaseErrorCode.InvalidOrigin.getErrorCodeNumber()};
    private static int[] e = new int[]{BaseErrorCode.AccessDeniedOrFileNotExists.getErrorCodeNumber()};
    private static int[] f = new int[]{BaseErrorCode.ServiceUnavailable.getErrorCodeNumber()};

    public static <T extends Enum<?>> void register(Class<? extends T> clazz) throws IllegalStateException {
        ErrorCode[] errorCodeArray;
        for (ErrorCode errorCode : errorCodeArray = (ErrorCode[])clazz.getEnumConstants()) {
            ErrorCode errorCode2 = a.put(errorCode.getErrorCodeNumber(), errorCode);
            if (errorCode2 == null) continue;
            throw new IllegalStateException("Duplicate code: " + errorCode.getErrorCodeNumber() + ", " + String.valueOf(errorCode2.getClass()) + ", " + String.valueOf(clazz));
        }
    }

    public static synchronized void addNoStackCode(ErrorCode errorCode) {
        b = ErrorCodeHelper.a(b, errorCode);
    }

    public static synchronized void addUnauthorizedCode(ErrorCode errorCode) {
        c = ErrorCodeHelper.a(c, errorCode);
    }

    public static synchronized void addForbiddenCode(ErrorCode errorCode) {
        d = ErrorCodeHelper.a(d, errorCode);
    }

    public static synchronized void addNotFoundCode(ErrorCode errorCode) {
        e = ErrorCodeHelper.a(e, errorCode);
    }

    public static synchronized void addServiceUnavailable(ErrorCode errorCode) {
        f = ErrorCodeHelper.a(f, errorCode);
    }

    private static synchronized int[] a(int[] nArray, ErrorCode errorCode) {
        int n2 = errorCode.getErrorCodeNumber();
        if (Arrays.binarySearch(nArray, n2) < 0) {
            int n3 = nArray.length;
            int[] nArray2 = Arrays.copyOf(nArray, n3 + 1);
            nArray2[n3] = n2;
            Arrays.sort(nArray2);
            nArray = nArray2;
        }
        return nArray;
    }

    public static boolean isHideStackTraceToUser(@Nonnull Throwable th, @Nullable HttpServletRequest request) {
        if (th instanceof HasErrorCode && Arrays.binarySearch(b, ((HasErrorCode)((Object)th)).getErrorCode()) >= 0) {
            return true;
        }
        if (request == null) {
            return false;
        }
        String string = request.getHeader("X-Forwarded-For");
        if (string != null && !URLPermissionChecker.isLocalHost(string)) {
            return true;
        }
        string = request.getRemoteAddr();
        return !URLPermissionChecker.isLocalHost(string);
    }

    private static boolean a(Throwable throwable, int[] nArray) {
        return throwable instanceof HasErrorCode && Arrays.binarySearch(nArray, ((HasErrorCode)((Object)throwable)).getErrorCode()) >= 0;
    }

    public static boolean isUnauthorizedCode(Throwable th) {
        return ErrorCodeHelper.a(th, c);
    }

    public static boolean isForbiddenCode(Throwable th) {
        return ErrorCodeHelper.a(th, d);
    }

    public static boolean isNotFoundCode(Throwable th) {
        return ErrorCodeHelper.a(th, e) || th instanceof FileNotFoundException;
    }

    public static boolean isServiceUnavailable(Throwable th) {
        return ErrorCodeHelper.a(th, f);
    }

    public static int getHttpStatusCode(Throwable th) {
        if (ErrorCodeHelper.isUnauthorizedCode(th)) {
            return 401;
        }
        if (ErrorCodeHelper.isNotFoundCode(th)) {
            return 404;
        }
        if (ErrorCodeHelper.isForbiddenCode(th)) {
            return 403;
        }
        if (ErrorCodeHelper.isServiceUnavailable(th)) {
            return 503;
        }
        if (th instanceof HttpFailedException) {
            return ((HttpFailedException)th).getHttpStatusCode();
        }
        return 500;
    }

    static ResourceBundle a(String string, @Nullable Object object) {
        return LoaderUtils.getBundle(string, ClientLocale.getThreadLocale(), object);
    }

    static {
        ErrorCodeHelper.register(BaseErrorCode.class);
    }
}

