/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.internal;

import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigKeyParser;
import com.inet.config.internal.LicenseCallbackPluginServlet;
import com.inet.error.ErrorCode;
import com.inet.http.security.TrustAllTrustManager;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class PrivateCloudLicenseTimerTask
extends DefaultTimerTask {
    private static final Set<String> a = ConcurrentHashMap.newKeySet();
    private static final MemoryStoreMap<String, String> b = new MemoryStoreMap(600, false);
    private static final String WELLKNOWN_LICENSE_CHALLENGE = ".well-known/license-challenge/";
    private static boolean c = true;
    private String d;
    private int e;
    private final a f;

    private PrivateCloudLicenseTimerTask(@Nonnull String serverURL) {
        this.d = Objects.requireNonNull(serverURL);
        if (c) {
            c = false;
            this.f = new a();
            DynamicExtensionManager.getInstance().register(Filter.class, this.f);
        } else {
            this.f = null;
        }
    }

    public static void firstLicenseWasParsed() {
        c = false;
    }

    @Nonnull
    private static String a(@Nonnull URL uRL) {
        String string = uRL.toString();
        return string.endsWith("/") ? string : string + "/";
    }

    public static String externalUrlAssignable(@Nonnull URL serverURL) {
        String string = PrivateCloudLicenseTimerTask.a(serverURL);
        if (a.contains(string)) {
            return null;
        }
        Object object = (String)b.get(string);
        if (object != null) {
            return object;
        }
        if (ServerPluginManager.IS_SERVLET_API) {
            DefaultTimer.getInstance().schedule(new PrivateCloudLicenseTimerTask(string), 0L, 10000L);
            object = "Externally visible URL '" + string + "' was not validated. Validation to access this URL is running. Check again in a minute.";
        } else {
            object = "Externally visible URL can't validated without an webserver.";
        }
        b.put(string, (String)object);
        return object;
    }

    public static boolean isKnown(@Nonnull URL serverURL) {
        String string = PrivateCloudLicenseTimerTask.a(serverURL);
        return a.contains(string) || b.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URL was set from admin")
    public void runImpl() throws Throwable {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        if (serverPluginManager.getState() != ServerPluginManager.ServerPluginManagerState.INIT || !serverPluginManager.isInitFinish()) {
            return;
        }
        Logger logger = LogManager.getConfigLogger();
        logger.info("Checking license for externally visible URL: " + this.d);
        String string = GUID.generateNew().toString();
        byte[] byArray = GUID.generateNew().toString().getBytes();
        try {
            LicenseCallbackPluginServlet.putToken(string, byArray);
            URL uRL = new URL(new URL(this.d), WELLKNOWN_LICENSE_CHALLENGE + string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            try {
                byte[] byArray2;
                TrustAllTrustManager.trustAllCerticates(httpURLConnection, false);
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setReadTimeout(5000);
                int n2 = httpURLConnection.getResponseCode();
                if (n2 == 200 && Arrays.equals(byArray, byArray2 = IOFunctions.readBytes(httpURLConnection.getInputStream()))) {
                    a.add(this.d.toString());
                    b.remove(this.d.toString());
                    this.cancel();
                    ConfigKeyParser.reset();
                    return;
                }
            }
            catch (IOException iOException) {
                logger.error(iOException);
            }
            String string2 = "Check of externally visible URL '" + this.d + "' and license token request returns: " + StringFunctions.getUserFriendlyErrorMessage(httpURLConnection);
            logger.error(string2);
            b.put(this.d, string2);
        }
        finally {
            LicenseCallbackPluginServlet.removeToken(string);
        }
        if (++this.e > 5) {
            this.cancel();
        }
    }

    @Override
    public boolean cancel() {
        if (this.f != null) {
            DynamicExtensionManager.getInstance().unregister(Filter.class, this.f);
        }
        return super.cancel();
    }

    private class a
    implements Filter {
        private final Object b = new Object();

        private a() {
        }

        @Override
        public void init(FilterConfig filterConfig) throws ServletException {
            ForkJoinPool.commonPool().execute(() -> {
                PrivateCloudLicenseTimerTask.this.run();
                if (PrivateCloudLicenseTimerTask.this.f != null) {
                    DynamicExtensionManager.getInstance().unregister(Filter.class, PrivateCloudLicenseTimerTask.this.f);
                }
                Object object = this.b;
                synchronized (object) {
                    this.b.notifyAll();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (!((HttpServletRequest)request).getRequestURI().contains(PrivateCloudLicenseTimerTask.WELLKNOWN_LICENSE_CHALLENGE) && !ConfigKeyParser.getCurrent().isValid()) {
                Object object = this.b;
                synchronized (object) {
                    try {
                        this.b.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ErrorCode.throwAny(interruptedException);
                    }
                }
            }
            chain.doFilter(request, response);
        }

        @Override
        public void destroy() {
        }
    }
}

