/*
 * Decompiled with CFR 0.152.
 */
package jbarcodebean;

import java.io.Serializable;
import jbarcodebean.AbstractBarcodeStrategy;
import jbarcodebean.BarcodeException;

public class Interleaved25
extends AbstractBarcodeStrategy
implements Serializable {
    private static AbstractBarcodeStrategy.CharacterCode[] codes = new AbstractBarcodeStrategy.CharacterCode[]{new AbstractBarcodeStrategy.CharacterCode('1', new byte[]{3, 1, 1, 1, 3}, 1), new AbstractBarcodeStrategy.CharacterCode('2', new byte[]{1, 3, 1, 1, 3}, 2), new AbstractBarcodeStrategy.CharacterCode('3', new byte[]{3, 3, 1, 1, 1}, 3), new AbstractBarcodeStrategy.CharacterCode('4', new byte[]{1, 1, 3, 1, 3}, 4), new AbstractBarcodeStrategy.CharacterCode('5', new byte[]{3, 1, 3, 1, 1}, 5), new AbstractBarcodeStrategy.CharacterCode('6', new byte[]{1, 3, 3, 1, 1}, 6), new AbstractBarcodeStrategy.CharacterCode('7', new byte[]{1, 1, 1, 3, 3}, 7), new AbstractBarcodeStrategy.CharacterCode('8', new byte[]{3, 1, 1, 3, 1}, 8), new AbstractBarcodeStrategy.CharacterCode('9', new byte[]{1, 3, 1, 3, 1}, 9), new AbstractBarcodeStrategy.CharacterCode('0', new byte[]{1, 1, 3, 3, 1}, 0), new AbstractBarcodeStrategy.CharacterCode('A', new byte[]{1, 1, 1, 1}, -1), new AbstractBarcodeStrategy.CharacterCode('B', new byte[]{3, 1, 1}, -1)};

    public int requiresChecksum() {
        return 2;
    }

    protected AbstractBarcodeStrategy.CharacterCode[] getCodes() {
        return codes;
    }

    protected String augmentWithChecksum(String string) throws BarcodeException {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            AbstractBarcodeStrategy.CharacterCode characterCode = this.getCharacterCode(c);
            if (characterCode == null) {
                throw new BarcodeException("Invalid character in barcode");
            }
            if (characterCode.check <= 0) continue;
            if ((n + string.length()) % 2 == 0) {
                n2 += characterCode.check;
                continue;
            }
            n3 += characterCode.check;
        }
        n = (10 - (n2 + (n3 *= 3)) % 10) % 10;
        string = string + new Integer(n).toString();
        return string;
    }

    protected String postprocess(String string) {
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        return string;
    }

    protected String preprocess(String string) {
        return string;
    }

    protected boolean isInterleaved() {
        return true;
    }

    protected char getStartSentinel() {
        return 'A';
    }

    protected char getStopSentinel() {
        return 'B';
    }

    protected byte getMarginWidth() {
        return 11;
    }

    protected String getBarcodeLabelText(String string) {
        return string;
    }
}

