/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jeuclid.font.FontFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFontFactory
extends FontFactory {
    private final Map<String, Font> fontCache = new HashMap<String, Font>();
    private static final String AWT_SANSSERIF = "sansserif";

    DefaultFontFactory() {
        this.autoloadFontsFromAWT();
    }

    private void autoloadFontsFromAWT() {
        String[] fam;
        for (String element : fam = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            Font f = new Font(element, 0, 12);
            this.cacheFont(f);
        }
    }

    @Override
    public Font getFont(String name, int style, int size) {
        Font font = this.fontCache.get(name);
        font = font == null ? new Font(name, style, size) : font.deriveFont(style, size);
        return font;
    }

    @Override
    public Font getFont(List<String> preferredFonts, int codepoint, int style, int size) {
        Font font = this.searchFontList(preferredFonts, codepoint, style, size);
        if (font == null) {
            font = this.searchFontList(this.fontCache.keySet(), codepoint, style, size);
        }
        if (font == null) {
            font = this.getFont(AWT_SANSSERIF, style, size);
        }
        return font;
    }

    private Font searchFontList(Collection<String> fontList, int codepoint, int style, int size) {
        for (String fontName : fontList) {
            Font font = this.getFont(fontName, style, size);
            String desiredFont = fontName.trim();
            if (!font.getFamily().equalsIgnoreCase(desiredFont) && !font.getFontName().equalsIgnoreCase(desiredFont) || !font.canDisplay(codepoint)) continue;
            return font;
        }
        return null;
    }

    @Override
    public Font registerFont(int format, File fontFile) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(format, fontFile));
    }

    @Override
    public Font registerFont(int format, InputStream fontStream) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(format, fontStream));
    }

    protected Font cacheFont(Font font) {
        this.fontCache.put(font.getFontName(), font);
        String family = font.getFamily();
        if (!this.fontCache.containsKey(family)) {
            this.fontCache.put(font.getFamily(), font);
        }
        return font;
    }
}

