/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import java.awt.Graphics2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.script.AbstractSubSuper;
import org.w3c.dom.DOMException;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLScriptElement;

public class Msup
extends AbstractSubSuper
implements MathMLScriptElement {
    public static final String ELEMENT = "msup";

    public Msup(MathBase base) {
        super(base);
    }

    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        JEuclidElement e1 = this.getMathElement(0);
        JEuclidElement e2 = this.getMathElement(1);
        float posY2 = posY - this.getSuperBaseLineShift(g);
        e1.paint(g, posX, posY);
        e2.paint(g, posX + e1.getWidth(g), posY2);
    }

    public float calculateWidth(Graphics2D g) {
        return this.getMathElement(0).getWidth(g) + this.getMathElement(1).getWidth(g);
    }

    public float calculateAscentHeight(Graphics2D g) {
        return this.caclulateAscentHeightWithSuper(g);
    }

    public float calculateDescentHeight(Graphics2D g) {
        return this.getMathElement(0).getDescentHeight(g);
    }

    public int getScriptlevelForChild(JEuclidElement child) {
        if (child.isSameNode(this.getFirstChild())) {
            return this.getAbsoluteScriptLevel();
        }
        return this.getAbsoluteScriptLevel() + 1;
    }

    public boolean isChildBlock(JEuclidElement child) {
        if (child.isSameNode(this.getFirstChild())) {
            return super.isChildBlock(child);
        }
        return false;
    }

    public String getTagName() {
        return ELEMENT;
    }

    public JEuclidElement getBase() {
        return this.getMathElement(0);
    }

    public JEuclidElement getSubscript() {
        return null;
    }

    public JEuclidElement getSuperscript() {
        return this.getMathElement(1);
    }

    public void setBase(MathMLElement base) {
        this.setMathElement(0, base);
    }

    public void setSubscript(MathMLElement subscript) {
        throw new DOMException(3, "msup does not have subscript");
    }

    public void setSuperscript(MathMLElement superscript) {
        this.setMathElement(1, superscript);
    }
}

