package com.inet.samples.propertieschecker;

import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.PropertiesChecker;

/**
 * Server plugin which registers a PropertiesChecker.
 */
@PluginInfo( //
id = "propertieschecker",// 
dependencies = "reporting", //
group = "samples", //
version = "25.10.233", //
icon = "com/inet/samples/propertieschecker/prop_checker_48.png" //
)
public class PropertiesCheckerPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        spm.register( PropertiesChecker.class, new CustomPropertiesChecker() );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
