/*
 * Decompiled with CFR 0.152.
 */
package jbarcodebean;

import java.io.Serializable;
import jbarcodebean.AbstractBarcodeStrategy;
import jbarcodebean.BarcodeException;

public class Ean13
extends AbstractBarcodeStrategy
implements Serializable {
    private static AbstractBarcodeStrategy.CharacterCode[] codes = new AbstractBarcodeStrategy.CharacterCode[]{new AbstractBarcodeStrategy.CharacterCode('0', new byte[]{3, 2, 1, 1}, 0), new AbstractBarcodeStrategy.CharacterCode('1', new byte[]{2, 2, 2, 1}, 1), new AbstractBarcodeStrategy.CharacterCode('2', new byte[]{2, 1, 2, 2}, 2), new AbstractBarcodeStrategy.CharacterCode('3', new byte[]{1, 4, 1, 1}, 3), new AbstractBarcodeStrategy.CharacterCode('4', new byte[]{1, 1, 3, 2}, 4), new AbstractBarcodeStrategy.CharacterCode('5', new byte[]{1, 2, 3, 1}, 5), new AbstractBarcodeStrategy.CharacterCode('6', new byte[]{1, 1, 1, 4}, 6), new AbstractBarcodeStrategy.CharacterCode('7', new byte[]{1, 3, 1, 2}, 7), new AbstractBarcodeStrategy.CharacterCode('8', new byte[]{1, 2, 1, 3}, 8), new AbstractBarcodeStrategy.CharacterCode('9', new byte[]{3, 1, 1, 2}, 9), new AbstractBarcodeStrategy.CharacterCode('a', new byte[]{1, 1, 2, 3}, 0), new AbstractBarcodeStrategy.CharacterCode('b', new byte[]{1, 2, 2, 2}, 1), new AbstractBarcodeStrategy.CharacterCode('c', new byte[]{2, 2, 1, 2}, 2), new AbstractBarcodeStrategy.CharacterCode('d', new byte[]{1, 1, 4, 1}, 3), new AbstractBarcodeStrategy.CharacterCode('e', new byte[]{2, 3, 1, 1}, 4), new AbstractBarcodeStrategy.CharacterCode('f', new byte[]{1, 3, 2, 1}, 5), new AbstractBarcodeStrategy.CharacterCode('g', new byte[]{4, 1, 1, 1}, 6), new AbstractBarcodeStrategy.CharacterCode('h', new byte[]{2, 1, 3, 1}, 7), new AbstractBarcodeStrategy.CharacterCode('i', new byte[]{3, 1, 2, 1}, 8), new AbstractBarcodeStrategy.CharacterCode('j', new byte[]{2, 1, 1, 3}, 9), new AbstractBarcodeStrategy.CharacterCode('A', new byte[]{1, 1, 1}, -1), new AbstractBarcodeStrategy.CharacterCode('B', new byte[]{1, 1, 1}, -1), new AbstractBarcodeStrategy.CharacterCode('C', new byte[]{1, 1, 1, 1, 1}, -1)};
    private static char[] bPattern = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};
    protected String checkSum;

    public int requiresChecksum() {
        return 1;
    }

    protected AbstractBarcodeStrategy.CharacterCode[] getCodes() {
        return codes;
    }

    protected void computeChecksum(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        this.checkSum = "";
        if (string.length() == n) {
            for (int i = n - 1; i >= 0; i -= 2) {
                n2 += Integer.parseInt(string.substring(i, i + 1));
                if (i <= 0) break;
                n3 += Integer.parseInt(string.substring(i - 1, i));
            }
            int n4 = (n2 *= 3) + n3;
            n2 = n4 / 10;
            n3 = n4 % 10;
            if (n3 != 0) {
                ++n2;
            }
            this.checkSum = new Integer(n2 * 10 - n4).toString();
        }
    }

    protected String augmentWithChecksum(String string) throws BarcodeException {
        return string + this.checkSum;
    }

    protected String postprocess(String string) {
        return string;
    }

    protected String preprocess(String string) {
        if (string.length() < 12) {
            return string;
        }
        string = string.substring(0, 12);
        this.computeChecksum(string, 12);
        char[] cArray = (string.substring(1, 7) + "C" + string.substring(7)).toCharArray();
        switch (string.charAt(0)) {
            case '0': {
                break;
            }
            case '1': {
                cArray[2] = bPattern[this.getCharacterCode((char)cArray[2]).check];
                cArray[4] = bPattern[this.getCharacterCode((char)cArray[4]).check];
                cArray[5] = bPattern[this.getCharacterCode((char)cArray[5]).check];
                break;
            }
            case '2': {
                cArray[2] = bPattern[this.getCharacterCode((char)cArray[2]).check];
                cArray[3] = bPattern[this.getCharacterCode((char)cArray[3]).check];
                cArray[5] = bPattern[this.getCharacterCode((char)cArray[5]).check];
                break;
            }
            case '3': {
                cArray[2] = bPattern[this.getCharacterCode((char)cArray[2]).check];
                cArray[3] = bPattern[this.getCharacterCode((char)cArray[3]).check];
                cArray[4] = bPattern[this.getCharacterCode((char)cArray[4]).check];
                break;
            }
            case '4': {
                cArray[1] = bPattern[this.getCharacterCode((char)cArray[1]).check];
                cArray[4] = bPattern[this.getCharacterCode((char)cArray[4]).check];
                cArray[5] = bPattern[this.getCharacterCode((char)cArray[5]).check];
                break;
            }
            case '5': {
                cArray[1] = bPattern[this.getCharacterCode((char)cArray[1]).check];
                cArray[2] = bPattern[this.getCharacterCode((char)cArray[2]).check];
                cArray[5] = bPattern[this.getCharacterCode((char)cArray[5]).check];
                break;
            }
            case '6': {
                cArray[1] = bPattern[this.getCharacterCode((char)cArray[1]).check];
                cArray[2] = bPattern[this.getCharacterCode((char)cArray[2]).check];
                cArray[3] = bPattern[this.getCharacterCode((char)cArray[3]).check];
                break;
            }
            case '7': {
                cArray[1] = bPattern[this.getCharacterCode((char)cArray[1]).check];
                cArray[3] = bPattern[this.getCharacterCode((char)cArray[3]).check];
                cArray[5] = bPattern[this.getCharacterCode((char)cArray[5]).check];
                break;
            }
            case '8': {
                cArray[1] = bPattern[this.getCharacterCode((char)cArray[1]).check];
                cArray[3] = bPattern[this.getCharacterCode((char)cArray[3]).check];
                cArray[4] = bPattern[this.getCharacterCode((char)cArray[4]).check];
                break;
            }
            case '9': {
                cArray[1] = bPattern[this.getCharacterCode((char)cArray[1]).check];
                cArray[2] = bPattern[this.getCharacterCode((char)cArray[2]).check];
                cArray[4] = bPattern[this.getCharacterCode((char)cArray[4]).check];
            }
        }
        return new String(cArray);
    }

    protected boolean isInterleaved() {
        return false;
    }

    protected char getStartSentinel() {
        return 'A';
    }

    protected char getStopSentinel() {
        return 'B';
    }

    protected byte getMarginWidth() {
        return 11;
    }

    protected String getBarcodeLabelText(String string) {
        if (string.length() < 12) {
            return string;
        }
        return string.substring(0, 12) + this.checkSum;
    }
}

