/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.error.HasErrorCode;
import com.inet.viewer.PromptData;
import com.inet.viewer.ViewerUtils;
import java.io.Serializable;

@JsonData
@PublicApi
public class ViewerException
extends RuntimeException
implements HasErrorCode,
Serializable {
    private static final long serialVersionUID = 8174976235156271L;
    private int errorCode;
    String format;
    String srvVersion;
    String srvJVM;
    String srvOS;
    int srvCache;
    String stacktrace;
    private PromptData[] prompts = null;
    private String supportEmail;
    private boolean needPrompts = false;

    private ViewerException(int errorCode, String message, String format, String srvVersion, String srvJVM, String srvOS, int srvCache) {
        super(message);
        this.errorCode = errorCode;
        this.format = format;
        this.srvVersion = srvVersion;
        this.srvJVM = srvJVM;
        this.srvOS = srvOS;
        this.srvCache = srvCache;
    }

    public ViewerException(int errorCode, String message, String format, String srvVersion, String srvJVM, String srvOS, int srvCache, String stacktrace) {
        this(errorCode, message, format, srvVersion, srvJVM, srvOS, srvCache, stacktrace, (String)null);
    }

    ViewerException(int errorCode, String message, String format, String srvVersion, String srvJVM, String srvOS, int srvCache, String stacktrace, String supportEmail) {
        this(errorCode, message, format, srvVersion, srvJVM, srvOS, srvCache);
        this.stacktrace = stacktrace;
        this.supportEmail = supportEmail;
    }

    public ViewerException(int errorCode, String message, String format, String srvVersion, String srvJVM, String srvOS, int srvCache, Throwable cause) {
        this(errorCode, message, format, srvVersion, srvJVM, srvOS, srvCache);
        this.initCause(cause);
    }

    public ViewerException(int errorCode, String message, String format, String srvVersion, String srvJVM, String srvOS, int srvCache, String protocol, Throwable cause) {
        this(errorCode, message, format, srvVersion, srvJVM, srvOS, srvCache, protocol, cause, null);
    }

    public ViewerException(int errorCode, String message, String format, String srvVersion, String srvJVM, String srvOS, int srvCache, String protocol, Throwable cause, String supportEmail) {
        this(errorCode, message, format, srvVersion, srvJVM, srvOS, srvCache, cause);
        ViewerUtils.setVersionInfo(protocol, srvVersion);
        this.supportEmail = supportEmail;
    }

    public ViewerException(String message) {
        super(message);
    }

    public ViewerException(String message, Throwable cause) {
        super(message, cause);
    }

    public static ViewerException createViewerException(Throwable cause) {
        if (cause instanceof ViewerException) {
            return (ViewerException)cause;
        }
        return new ViewerException(ViewerException.getErrorMessage(cause), cause);
    }

    public static ViewerException createViewerExceptionWithMessage(String message, Throwable cause) {
        if (cause instanceof ViewerException) {
            ViewerException viewerException = (ViewerException)cause;
            return new ViewerException(viewerException.errorCode, message + "\n" + viewerException.getMessage(), viewerException.format, viewerException.srvVersion, viewerException.srvJVM, viewerException.srvOS, viewerException.srvCache, viewerException.stacktrace);
        }
        return new ViewerException(message, cause);
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    public static String getErrorMessage(Throwable th) {
        String string = th.getLocalizedMessage();
        if (string == null || string.length() < 20 || string.indexOf(32) < 0) {
            String[] stringArray;
            String string2 = th.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
            if (th instanceof ViewerException || string2.equals("ReportException")) {
                if (string == null) {
                    string = "";
                }
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray = string2.split("(?<=[a-z])(?=[A-Z])")) {
                if (string3.equals("Exception") && stringBuilder.length() > 0) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string3);
            }
            if (string != null) {
                stringBuilder.append(": ").append(string);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public ViewerException(PromptData[] prompts) {
        super("NeedsPrompts");
        this.setPrompts(prompts);
        this.setNeedPrompts(true);
        ViewerUtils.debug("Creating Viewer Exception - PROMPTS!");
    }

    public void setPrompts(PromptData[] prompts) {
        this.prompts = prompts;
    }

    public PromptData[] getPrompts() {
        return this.prompts;
    }

    public void setNeedPrompts(boolean needPrompts) {
        this.needPrompts = needPrompts;
    }

    public boolean isNeedPrompts() {
        return this.needPrompts;
    }

    String getSupportEmail() {
        return this.supportEmail;
    }
}

