/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.viewer.PromptValue;
import java.util.Iterator;
import java.util.Vector;

@JsonData
@PublicApi
class MultiPromptValue
extends PromptValue {
    private Vector values = new Vector();
    private static final long serialVersionUID = 97567848828211L;

    public MultiPromptValue(Vector defaultValue, String description, int type) {
        super(description, type);
        this.values = defaultValue;
    }

    public MultiPromptValue(int type) {
        super(type);
    }

    @Override
    public String toString() {
        String string = "";
        if (!this.isOnlyDescription()) {
            string = this.getValueString();
        } else {
            if (string.length() > 0) {
                string = string + " - ";
            }
            string = this.getDescription();
        }
        return string;
    }

    @Override
    public String getValueString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (Object e2 : this.getValues()) {
            if (e2 == null) continue;
            stringBuffer.append(((PromptValue)e2).toString());
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public Object getValue() {
        return this.getValues();
    }

    @Override
    void initValue() {
    }

    @Override
    public String getStringRepresentation() {
        Iterator iterator = this.getValues().iterator();
        StringBuffer stringBuffer = new StringBuffer("[");
        while (iterator.hasNext()) {
            PromptValue promptValue = (PromptValue)iterator.next();
            if (promptValue != null) {
                String string = promptValue.getStringRepresentation();
                stringBuffer.append(string);
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(",");
        }
        if (stringBuffer.length() == 1) {
            return "[]";
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ']');
        return stringBuffer.toString();
    }

    @Override
    public Object getSQLTypedValue() {
        return null;
    }

    Vector getValues() {
        return this.values;
    }
}

