/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.Progress;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.i18n.a;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class ExportProgress
extends Progress {
    private RenderData b;
    private final RenderData c;
    private Properties d;
    private byte[] e;
    private int f;
    private int g;
    private ArrayList<String> h;

    public ExportProgress(ReportView parent, RenderData data, Properties exportProps) {
        super(parent, 2);
        this.setIndeterminate(true);
        this.a(null, false);
        this.c = data;
        this.d = exportProps;
    }

    ExportProgress(Component parent, ViewerContext viewerContext, RenderData data, Properties exportProps) {
        super(parent, viewerContext, 2);
        this.a(null, false);
        this.c = data;
        this.d = exportProps;
    }

    private void a(String string, boolean bl) {
        ReportView reportView = this.getReportView();
        if (reportView != null) {
            reportView.getReportViewer().getViewerContext().showStatusMessage(reportView, string, bl);
        }
    }

    @Override
    public final String getName() {
        return "Export Progress";
    }

    @Override
    public void cancel() {
        this.a().stop();
        this.setStatus(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Only used on client side")
    public void run() {
        this.h = new ArrayList();
        try {
            File file;
            RenderData renderData = this.a();
            String string = this.d.getProperty("export_fmt");
            int n2 = renderData.getExportChunkCount(this.d);
            this.setIndeterminate(false);
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            this.setTotalProgress(n2);
            String string2 = this.d.getProperty("file");
            if (string.startsWith("htm")) {
                file = this.a(string, string2);
            } else if (string.startsWith("svg")) {
                file = this.a(string, string2);
            } else if (string.equals("jpg") || string.equals("gif") || string.equals("png") || string.equals("bmp")) {
                file = this.a(string2, n2);
            } else {
                byte[] byArray;
                file = new File(string2);
                this.h.add(file.getPath());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                for (int i2 = 1; i2 <= n2 && (byArray = renderData.getNextExportChunk()) != null; ++i2) {
                    fileOutputStream.write(byArray);
                    this.setProgress(i2);
                }
                fileOutputStream.close();
            }
            this.a(com.inet.viewer.i18n.a.a("export.finished"), false);
            this.setStatus(2);
            if (this.d.getProperty("exportInApplication", "false").equals("true") && file != null) {
                this.a(file);
            }
        }
        catch (Throwable throwable) {
            ViewerUtils.printStackTrace(throwable);
            if (this.getStatus() == 3) {
                ViewerUtils.log("Export: Export canceled by user");
                this.a(com.inet.viewer.i18n.a.a("export.canceled"), false);
            } else {
                this.showError(throwable);
                this.a(com.inet.viewer.i18n.a.a("export.failed"), true);
                this.setStatus(4);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    public ArrayList<String> getFileNames() {
        return this.h;
    }

    private final void a(File file) {
        try {
            if (ViewerUtils.useDesktopMethod("open", file)) {
                return;
            }
            ViewerUtils.showDocumentOldMethod(file);
        }
        catch (Throwable throwable) {
            this.showError(new ViewerException(com.inet.viewer.i18n.a.a("export.inApplicationFailed"), throwable));
        }
    }

    private int a(byte[] byArray, int n2) {
        return (byArray[n2 + 0] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + (byArray[n2 + 3] << 24);
    }

    private boolean a(int n2, boolean bl) throws ViewerException {
        int n3 = this.g - this.f;
        if (n3 < n2) {
            byte[] byArray = this.a().getNextExportChunk();
            this.setProgress(this.getProgress() + 1);
            if (byArray == null) {
                if (bl) {
                    throw new ViewerException(com.inet.viewer.i18n.a.a("error.export.unexpected_end"));
                }
                return false;
            }
            if (this.e == null) {
                this.e = byArray;
                this.f = 0;
                this.g = byArray.length;
            } else {
                if (this.e.length - n3 < byArray.length) {
                    byte[] byArray2 = new byte[n3 + byArray.length];
                    System.arraycopy(this.e, this.f, byArray2, 0, n3);
                    this.e = byArray2;
                } else {
                    System.arraycopy(this.e, this.f, this.e, 0, n3);
                }
                this.f = 0;
                this.g = n3;
                System.arraycopy(byArray, 0, this.e, this.g, byArray.length);
                this.g += byArray.length;
            }
        }
        return true;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT"}, justification="Caller must check it")
    private File a(String string, String string2) throws IOException {
        this.f = 0;
        File file = null;
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        while (this.g > this.f || this.getTotalProgress() > this.getProgress()) {
            int n2;
            FileOutputStream fileOutputStream;
            String string4;
            this.a(4, true);
            int n3 = this.a(this.e, this.f);
            if (n3 == -1) break;
            if (n3 > 512) {
                throw new ViewerException(0, com.inet.viewer.i18n.a.a("error.export.data_wrong"), string, null, null, null, 0, new String(this.e, 0, this.g));
            }
            this.f += 4;
            this.a(n3, true);
            String string5 = new String(this.e, this.f, n3, "UTF8");
            if (!bl2) {
                string4 = this.d.getProperty("layout");
                if (string4 == null) {
                    if (!string2.substring(string2.lastIndexOf(46)).equals(string5.substring(string5.lastIndexOf(46)))) {
                        string5 = string5.substring(0, string5.lastIndexOf(46)) + string2.substring(string2.lastIndexOf(46));
                    }
                    string2 = string2.substring(0, string2.lastIndexOf(47) + 1) + string5;
                }
                file = new File(string2);
                file.getParentFile().mkdirs();
                this.h.add(file.getPath());
                fileOutputStream = new FileOutputStream(file);
                string3 = string5.substring(0, string5.lastIndexOf(46));
                bl2 = true;
            } else {
                StringBuffer stringBuffer = new StringBuffer(string2.substring(0, string2.lastIndexOf(47) + 1));
                stringBuffer.append(string3);
                if (!bl) {
                    this.a(stringBuffer.toString());
                    bl = true;
                }
                stringBuffer.append('/');
                stringBuffer.append(string5);
                string4 = stringBuffer.toString();
                this.h.add(string4);
                fileOutputStream = new FileOutputStream(string4);
            }
            this.f += n3;
            this.a(4, true);
            this.f += 4;
            for (n3 = this.a(this.e, this.f); n3 > 0; n3 -= n2) {
                this.a(1, true);
                n2 = Math.min(this.g - this.f, n3);
                fileOutputStream.write(this.e, this.f, n2);
                this.f += n2;
            }
            fileOutputStream.close();
        }
        return file;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private File a(String object, int n2) throws IOException {
        Object object2;
        RenderData renderData = this.a();
        byte[] byArray = renderData.getNextExportChunk();
        if (byArray.length > 2 && byArray[0] == 80 && byArray[1] == 75 && !((String)object).endsWith(".zip")) {
            object2 = (String)object + ".zip";
            if (new File((String)object2).exists()) {
                int n3 = 1;
                while (new File((String)(object2 = (String)object + "(" + n3++ + ").zip")).exists()) {
                }
            }
            object = object2;
        }
        object2 = new File((String)object);
        this.h.add(((File)object2).getPath());
        FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
        for (int i2 = 1; i2 <= n2 && byArray != null; ++i2) {
            ((OutputStream)fileOutputStream).write(byArray);
            this.setProgress(1);
            if (i2 >= n2) break;
            byArray = renderData.getNextExportChunk();
        }
        ((OutputStream)fileOutputStream).close();
        return object2;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private void a(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new RuntimeException("\n" + com.inet.viewer.i18n.a.a("error.export.cannot_delete") + " " + string);
            }
            file.mkdirs();
        }
    }

    private synchronized RenderData a() {
        if (this.b == null) {
            this.b = this.c.getCopy();
        }
        return this.b;
    }
}

