/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.BooleanFieldValue;

public abstract class BooleanGroupFieldDefinition
extends GroupFieldDefinition<Boolean> {
    public BooleanGroupFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_boolean", prio);
    }

    public BooleanGroupFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, fieldKey, displayType, prio);
    }

    @Override
    public BooleanFieldValue getFieldValue(UserGroupInfo userGroup) {
        Boolean bl = null;
        if (userGroup != null) {
            bl = (Boolean)userGroup.getValue(UserGroupManager.getRecoveryEnabledInstance().getField(this.getFieldKey()));
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        BooleanFieldValue booleanFieldValue = new BooleanFieldValue(bl.toString(), this.getLabel());
        return booleanFieldValue;
    }

    @Override
    public Boolean convertFromString(String value) {
        return Boolean.valueOf(value);
    }
}

