/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.index;

import com.inet.annotations.JsonData;
import com.inet.search.index.IndexSearchEngine;

@JsonData
public class IndexerStatus {
    private boolean running;
    private long indexed;
    private long toBeIndexed;
    private long runningStartTime;
    private String indexerName;

    public IndexerStatus(boolean running, long indexed, long toBeIndexed, long runningStartTime) {
        this("", running, indexed, toBeIndexed, runningStartTime);
    }

    public IndexerStatus(String indexerName, boolean running, long indexed, long toBeIndexed, long runningStartTime) {
        this.indexerName = indexerName;
        this.running = running;
        this.indexed = indexed;
        this.toBeIndexed = toBeIndexed;
        this.runningStartTime = runningStartTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getIndexed() {
        return this.indexed;
    }

    public long getToBeIndexed() {
        return this.toBeIndexed;
    }

    public long getRunningStartTime() {
        return this.runningStartTime;
    }

    public double getIndexingPerMinute() {
        long l2 = this.getIndexed();
        long l3 = this.getRunningStartTime();
        if (l3 == 0L) {
            return -1.0;
        }
        long l4 = System.currentTimeMillis();
        double d2 = (double)(l4 - l3) / 1000.0;
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = (double)l2 / d2 * 60.0;
        return (double)Math.round(d3 * 100.0) / 100.0;
    }

    public long estimateRemainingIndexTimeInMinutes() {
        long l2 = this.getToBeIndexed();
        long l3 = this.getIndexed();
        double d2 = this.getIndexingPerMinute();
        long l4 = Math.max(0L, l2 - l3);
        if (l4 == 0L || d2 <= 0.0) {
            return 0L;
        }
        return (long)Math.ceil((double)l4 / d2);
    }

    public String getEstimatedRemainingIndexTimeAsString() {
        long l2 = this.estimateRemainingIndexTimeInMinutes();
        if (l2 == 0L) {
            return "";
        }
        return l2 <= 90L ? IndexSearchEngine.MSG.getMsg("indexerStatus.estimatedRemainingTime.lessThanAnHour", l2) : IndexSearchEngine.MSG.getMsg("indexerStatus.estimatedRemainingTime.moreThanAnHour", l2 / 60L, Math.floorMod(l2, 60), l2 % 60L);
    }

    public String getRunningTimeAsString() {
        long l2 = (System.currentTimeMillis() - this.getRunningStartTime()) / 1000L;
        if (l2 < 0L) {
            return "";
        }
        long l3 = l2 / 3600L;
        long l4 = Math.floorMod(l2 / 60L, 60);
        long l5 = l2 - l3 * 60L * 60L - l4 * 60L;
        return IndexSearchEngine.MSG.getMsg("indexerStatus.runningTime.moreThanAMinute", l3, l4, l5);
    }

    public String getStatistics() {
        return this.getStatistics(IndexSearchEngine.MSG.getMsg("indexerStatus.defaultUnit", new Object[0]));
    }

    public String getStatistics(String indexingRateUnit) {
        long l2 = this.getIndexed();
        long l3 = this.getToBeIndexed();
        if (!this.isRunning() || l2 < 0L) {
            return IndexSearchEngine.MSG.getMsg("indexerStatus.detailsmessage", l3);
        }
        if (l2 > l3 && l3 > -1L) {
            l3 = -1L;
        }
        String string = this.getEstimatedRemainingIndexTimeAsString();
        String string2 = this.getRunningTimeAsString();
        if (IndexSearchEngine.LOGGER.isDebug()) {
            IndexSearchEngine.LOGGER.debug(this.indexerName + "|" + l2 + "|" + l3 + "|" + (System.currentTimeMillis() - this.getRunningStartTime()) / 1000L + "|" + this.getIndexingPerMinute() + "|" + this.estimateRemainingIndexTimeInMinutes() * 60L);
        }
        return IndexSearchEngine.MSG.getMsg("indexerStatus.detailsmessage.running", l2, l3, (long)this.getIndexingPerMinute(), string.length(), string, string2.length(), string2, indexingRateUnit);
    }
}

