/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.file;

import com.inet.annotations.InternalApi;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.SearchIndexPersistence;
import com.inet.persistence.file.a;
import com.inet.persistence.file.b;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.search.index.FileSearchIndexPersistence;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import java.io.File;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class FilePersistence
implements Persistence {
    private final File a;

    FilePersistence(File root) {
        this.a = root;
    }

    @Override
    @Nonnull
    public PersistenceEntry resolve(@Nonnull String path) {
        return new b(this.a, PersistenceHelper.resolve("/", path));
    }

    @Override
    public String getUID() {
        return Integer.toHexString(this.a.toString().hashCode());
    }

    public Path getPersistenceFolder() {
        return this.a.toPath();
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public EventLogPersistence getEventLogPersistence(String name) {
        return new a(new File(this.getPersistenceFolder().resolve("eventlog").toFile(), name + ".csv"));
    }

    @Override
    public <T> void registerListener(@Nonnull PersistenceListener<T> listener) {
    }

    @Override
    public <T> void sendEvent(@Nonnull T event) {
    }

    @Override
    public int getNodeCount() {
        return 1;
    }

    @Override
    public void registerNodeListener(@Nonnull PersistenceListener<Boolean> listener) {
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    public <ID> SearchIndexPersistence<ID> getSearchIndexPersistence(@Nonnull String name) {
        return new FileSearchIndexPersistence(new File(this.a, "index/" + name));
    }

    @Override
    @Nullable
    public ServerLock tryLock(@Nonnull String key) {
        return ThreadUtils.tryLock(key);
    }

    @Override
    @Nullable
    public ServerLock tryReadLock(@Nonnull String key) {
        return ThreadUtils.tryReadLock(key);
    }

    @Override
    @Nullable
    public ServerLock tryWriteLock(@Nonnull String key) {
        return ThreadUtils.tryWriteLock(key);
    }

    @Override
    @Nonnull
    public ServerLock getReadLock(@Nonnull String key, long timeout) {
        return ThreadUtils.getReadLock(key, timeout);
    }

    @Override
    @Nonnull
    public ServerLock getWriteLock(@Nonnull String key, long timeout) {
        return ThreadUtils.getWriteLock(key, timeout);
    }
}

