/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http;

import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.cache.CacheManager;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.BaseErrorCode;
import com.inet.error.BaseException;
import com.inet.error.ErrorCodeHelper;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginServlet;
import com.inet.http.RootServletProvider;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.servlet.FilterLoader;
import com.inet.http.servlet.SessionStore;
import com.inet.http.utils.MimeTypes;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.logging.PluginDispatcherEventLog;
import com.inet.persistence.Persistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.DynamicExtensionListener;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.shared.servlet.ServletUtils;
import com.inet.thread.SessionLocal;
import com.inet.thread.job.manager.JobManager;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PluginDispatcherServlet
extends HttpServlet
implements FilterChain {
    private static com.inet.http.a a;
    private static DynamicExtensionListener b;
    private static String c;
    private static String d;
    private static FilterLoader e;

    @Override
    public void init(final ServletConfig config) throws ServletException {
        Object object;
        if (e != null) {
            return;
        }
        super.init(config);
        ServletUtils.setServletContext(config.getServletContext());
        ServletUtils.loadConfigurationFromWebXml(config);
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        if (serverPluginManager.getState() == ServerPluginManager.ServerPluginManagerState.PRE_INIT) {
            try {
                object = serverPluginManager.loadCoreServerPluginDescriptionForServerStart(null);
                serverPluginManager.init((ServerPluginDescription)object);
            }
            catch (Exception exception) {
                throw new ServletException(exception);
            }
        }
        a = new com.inet.http.a(config, a);
        if (b == null) {
            b = new DynamicExtensionListener<Object>(){

                @Override
                public void valuesChanged(@Nonnull List values) {
                    try {
                        a = new com.inet.http.a(config, a);
                    }
                    catch (ServletException servletException) {
                        LogManager.getConfigLogger().error(servletException);
                    }
                }
            };
            object = b;
            DynamicExtensionManager.getInstance().registerListener(PluginServlet.class, object);
            DynamicExtensionManager.getInstance().registerListener(RootServletProvider.class, object);
        }
        c = ApplicationDescription.get().getVersion().toString();
        d = Persistence.getInstance().getUID();
        e = new FilterLoader(this);
    }

    @Override
    public void destroy() {
        if (a != null) {
            a.a();
        }
        if (e != null) {
            e.destroy();
        }
        LogManager.stopSpooler();
        CacheManager.stopMemoryObserver();
        JobManager.stop();
        super.destroy();
        a = null;
        e = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(ServletRequest req, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)req;
        try {
            httpServletRequest = ProxyHttpServletRequest.wrapRequestIfNeeded(httpServletRequest);
            SessionStore.setHttpServletRequest(httpServletRequest);
            e.doFilter(httpServletRequest, response);
        }
        catch (ClientMessageException clientMessageException) {
            ServletErrorHandler.sendErrorPage(httpServletRequest, (HttpServletResponse)response, clientMessageException);
        }
        catch (Throwable throwable) {
            if (ServletErrorHandler.isClientAbort(throwable)) {
                return;
            }
            if (ErrorCodeHelper.isUnauthorizedCode(throwable) || ErrorCodeHelper.isForbiddenCode(throwable)) {
                LoginProcessor.LOGGER.debug(throwable);
            } else if (ErrorCodeHelper.isServiceUnavailable(throwable)) {
                LogManager.getApplicationLogger().debug(throwable);
            } else {
                Logger logger = LogManager.getApplicationLogger();
                Object object = "";
                try {
                    String string = ((HttpServletRequest)req).getQueryString();
                    object = String.valueOf(throwable) + " [Request URL: " + String.valueOf(((HttpServletRequest)req).getRequestURL()) + (String)(StringFunctions.isEmpty(string) ? "" : "?" + string) + "]\n";
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                logger.error((String)object, throwable);
            }
            ServletErrorHandler.sendErrorPage(httpServletRequest, (HttpServletResponse)response, throwable);
        }
        finally {
            HttpServletResponse httpServletResponse;
            if (HttpServletResponse.class.isAssignableFrom(response.getClass()) && (httpServletResponse = (HttpServletResponse)response).getStatus() >= 400) {
                PluginDispatcherEventLog.Webserver.log(httpServletRequest, httpServletResponse);
            }
        }
        SessionStore.reset();
        SessionLocal.allRemoveThreadFromSession();
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)req;
        HttpServletResponse httpServletResponse = (HttpServletResponse)res;
        httpServletResponse.setHeader("X-Server-Version", c);
        if (d != null) {
            httpServletResponse.setHeader("X-Server-UID", d);
        }
        httpServletResponse.setHeader("X-DNS-Prefetch-Control", "off");
        Map<String, String> map = httpServletRequest.getScheme().equals("https") ? com.inet.http.PluginDispatcherServlet$a.f.get() : com.inet.http.PluginDispatcherServlet$a.e.get();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            httpServletResponse.setHeader(object2.getKey(), object2.getValue());
        }
        String string = com.inet.http.PluginDispatcherServlet$a.a.get();
        if (!StringFunctions.isEmpty(string)) {
            httpServletResponse.setHeader("X-Frame-Options", string);
        }
        String string2 = httpServletRequest.getRequestURI();
        int n2 = ServletUtils.getContextPathLength(httpServletRequest);
        String string3 = EncodingFunctions.decodeUrlPath(string2.substring(n2));
        String string4 = string2.substring(0, n2);
        if (string3.isEmpty()) {
            string3 = "/";
        }
        boolean bl = false;
        switch (string3) {
            case "/crossdomain.xml": {
                PluginDispatcherServlet.a(com.inet.http.PluginDispatcherServlet$a.b, httpServletRequest, httpServletResponse);
                return;
            }
            case "/robots.txt": {
                PluginDispatcherServlet.a(com.inet.http.PluginDispatcherServlet$a.c, httpServletRequest, httpServletResponse);
                return;
            }
            case "/.well-known/security.txt": {
                PluginDispatcherServlet.a(com.inet.http.PluginDispatcherServlet$a.d, httpServletRequest, httpServletResponse);
                return;
            }
            case "/.well-known/healthcheck.txt": {
                PluginDispatcherServlet.sendHealthCheck(httpServletRequest, httpServletResponse);
                return;
            }
            case "/favicon.ico": {
                PluginDispatcherServlet.sendFavicon(httpServletRequest, httpServletResponse, false);
                return;
            }
            case "/favicon.icns": {
                PluginDispatcherServlet.sendFavicon(httpServletRequest, httpServletResponse, true);
                return;
            }
            case "/pwaoffline/pwa-service-worker.js": 
            case "/pwa-service-worker.js": 
            case "/public/pwa-service-worker.js": {
                string3 = "/pwaoffline/pwa-service-worker.js";
                bl = true;
            }
        }
        if (!(bl || string3.endsWith("/weblib/manifest.webmanifest") || LoginManager.initHttpRequest(httpServletRequest, httpServletResponse))) {
            return;
        }
        SessionStore.setHttpServletRequest(httpServletRequest);
        ClientLocale.setThreadLocale(httpServletRequest);
        ClientTimezone.setTimeZone(httpServletRequest);
        PluginDispatcherServlet.a(string4, string3, httpServletRequest, httpServletResponse);
    }

    public static void forward(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PluginDispatcherServlet.a(request.getContextPath(), path, request, response);
    }

    private static void a(final String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string3;
        PluginServlet pluginServlet;
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID != null) {
            httpServletResponse.setHeader("X-User", gUID.toString());
        }
        if ((pluginServlet = a.a(string2)) == null) {
            pluginServlet = a.a(string2, httpServletRequest);
            string3 = "/";
        } else {
            string3 = pluginServlet.getPathSpec();
        }
        final String string4 = string3;
        final String string5 = string2.length() <= string4.length() ? null : (string4.length() == 1 ? string2 : string2.substring(string4.length()));
        httpServletRequest = new HttpServletRequestWrapper(httpServletRequest){

            @Override
            public String getPathInfo() {
                return string5;
            }

            @Override
            public String getServletPath() {
                return string4;
            }

            @Override
            public String getContextPath() {
                return string;
            }
        };
        if (pluginServlet != null) {
            pluginServlet.service(httpServletRequest, httpServletResponse);
            return;
        }
        if (ServerPluginManager.IS_SERVLET_API) {
            ServletErrorHandler.sendErrorPage(httpServletRequest, httpServletResponse, new BaseException(BaseErrorCode.AccessDeniedOrFileNotExists, null, string2));
        } else {
            httpServletResponse.sendError(500, "WebSocket API is missing");
        }
    }

    private static void a(ConfigValue<String> configValue, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = configValue.get();
        if (string == null || string.trim().isEmpty()) {
            ServletUtils.sendFileNotExist(httpServletRequest, httpServletResponse);
        } else {
            String string2 = MimeTypes.getMimeType(configValue.getConfigKey().getKey());
            if (string2 != null) {
                httpServletResponse.setContentType(string2);
            }
            httpServletResponse.getOutputStream().write(string.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void sendFavicon(HttpServletRequest request, HttpServletResponse response, boolean icns) throws IOException {
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        URL uRL = applicationDescription.getRemoteGuiInformation().getFaviconURL(icns);
        if (uRL == null) {
            ServletUtils.sendFileNotExist(request, response);
            return;
        }
        ServletUtils.sendStaticContent(uRL, request, response);
    }

    public static void sendHealthCheck(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain; charset=utf-8");
        response.setStatus(200);
        response.getOutputStream().write("OK".getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public static PluginServlet getRootServlet(HttpServletRequest request) {
        return a != null ? a.a("/", request) : null;
    }

    private static abstract class a {
        private static final ConfigValue<String> a = new ConfigValue<String>(ConfigKey.ALLOW_FRAME_EMBEDDING){

            public String a() {
                String string = (String)super.get();
                switch (string.toLowerCase()) {
                    case "deny": {
                        return "DENY";
                    }
                    case "sameorigin": {
                        return "SAMEORIGIN";
                    }
                }
                return null;
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        };
        private static final ConfigValue<String> b = new ConfigValue(ConfigKey.CROSSDOMAIN_XML);
        private static final ConfigValue<String> c = new ConfigValue(ConfigKey.ROBOTS_TXT);
        private static final ConfigValue<String> d = new ConfigValue(ConfigKey.SECURITY_TXT);
        private static final ConfigValue<Map<String, String>> e = new ConfigValue(ConfigKey.HTTP_HEADER_FIELDS);
        private static final ConfigValue<Map<String, String>> f = new ConfigValue(ConfigKey.HTTPS_HEADER_FIELDS);
    }
}

