/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.core;

import com.inet.authentication.ActiveAuthenticationProvider;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.MasterLoginData;
import com.inet.authentication.SystemAuthenticationProvider;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.stayloggedin.StayLoggedInHandler;
import com.inet.authentication.stayloggedin.StayLoggedInSession;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.provider.DefaultConfigurationProvider;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.StyledLabelConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.permissions.AnonymousLoginProcessor;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpAdminBackdoor;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CoreSecurityStructureProvider
extends AbstractStructureProvider {
    public static final CoreSecurityStructureProvider INSTANCE = new CoreSecurityStructureProvider();
    public static final String CATEGORY_LOGIN = "category.login";
    private static final String LOGIN_HELP = "security-login";
    private static final String GROUP_LOGIN = "group.login";
    private static final String ACTION_PREFIX = "login-provider-action.";
    private static final String ACTION_RESET_AUTH_GROUPS = "action.resetauthgroups";
    private static final String CATEGORY_USERS_AND_GROUPS = "category.usersandgroups";
    private static final String GROUP_USERS_AND_GROUPS = "group.usersandgroups";
    private static final String GROUP_RESET_AUTHENTICATION = "group.resetauthgroups";
    private static final String NO_DELETE = "no-delete";

    @Override
    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (!CoreSecurityStructureProvider.isDesigner()) {
            groups.add(new ConfigGroup(200, "categorygroup.security", this.translate(settings, "categorygroup.security", new Object[0]), this.getClass().getResource("server_categorygroup_security_48.png")));
        }
    }

    @Override
    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.security": {
                categories.add(new ConfigCategory(100, CATEGORY_LOGIN, this.translate(settings, CATEGORY_LOGIN, new Object[0]), LOGIN_HELP));
                categories.add(new ConfigCategory(200, CATEGORY_USERS_AND_GROUPS, this.translate(settings, CATEGORY_USERS_AND_GROUPS, new Object[0]), "security-users-and-groups"));
                break;
            }
        }
    }

    @Override
    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.login": {
                return this.getClass().getResource("login_48.png");
            }
            case "category.usersandgroups": {
                return this.getClass().getResource("usersandgroups_48.png");
            }
        }
        return null;
    }

    @Override
    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.login": {
                propertyGroups.add(new ConfigPropertyGroup(100, GROUP_LOGIN, this.translate(settings, "authentication.logintypes", new Object[0])));
                if (!advanced) break;
                ConfigAction configAction = new ConfigAction(ACTION_RESET_AUTH_GROUPS, this.translate(settings, ACTION_RESET_AUTH_GROUPS, new Object[0]));
                propertyGroups.add(new ConfigPropertyGroup(1500, GROUP_RESET_AUTHENTICATION, this.translate(settings, "authentication.resetgroups", new Object[0]), configAction));
                break;
            }
            case "category.usersandgroups": {
                propertyGroups.add(new ConfigPropertyGroup(100, GROUP_USERS_AND_GROUPS));
                break;
            }
        }
    }

    @Override
    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.login": {
                configProperties.add(this.a(advanced, settings, false));
                this.addTo(configProperties, ConfigKey.AUTHENTICATION_ALLOW_NEW_USER, settings);
                if (!Boolean.parseBoolean(settings.getValue(ConfigKey.SYSTEMPERMISSION_ENABLED))) {
                    Set<StyledLabelConfigProperty.Style> set = Set.of(StyledLabelConfigProperty.Style.danger, StyledLabelConfigProperty.Style.bold);
                    configProperties.add(new StyledLabelConfigProperty(set, configProperties.size() * 100, ConfigKey.AUTHENTICATION_ALLOW_NEW_USER.getKey() + ".attention", this.translate(settings, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey() + ".attention.label", new Object[0]), this.translate(settings, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey() + ".attention.description", new Object[0])));
                }
                this.addTo(configProperties, ConfigKey.AUTHENTICATION_STAY_LOGGED_IN, settings);
                break;
            }
            case "group.resetauthgroups": {
                configProperties.add(new ConfigProperty(0, propertyGroupKey, "Label", this.translate(settings, "authentication.resetgroups.description", new Object[0]), null, null, null));
                break;
            }
            case "group.usersandgroups": {
                configProperties.add(new BooleanConfigProperty(0, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey(), this.translate(settings, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey() + ".description", new Object[0]), this.translate(settings, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey(), new Object[0]), null, settings.getValue(ConfigKey.SYSTEMPERMISSION_ENABLED)));
                Set<StyledLabelConfigProperty.Style> set = Set.of(StyledLabelConfigProperty.Style.danger, StyledLabelConfigProperty.Style.bold);
                configProperties.add(new StyledLabelConfigProperty(set, configProperties.size() * 100, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey() + ".attention", this.translate(settings, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey() + ".attention.label", new Object[0]), this.translate(settings, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey() + ".attention.description", new Object[0])));
                if (!LoginManager.isGuestAccount()) break;
                configProperties.add(new BooleanConfigProperty(configProperties.size() * 100, ConfigKey.GUEST_FULL_PERMISSIONS.getKey(), this.translate(settings, ConfigKey.GUEST_FULL_PERMISSIONS.getKey() + ".description", new Object[0]), this.translate(settings, ConfigKey.GUEST_FULL_PERMISSIONS.getKey(), new Object[0]), null, settings.getValue(ConfigKey.GUEST_FULL_PERMISSIONS)));
                break;
            }
        }
    }

    @Override
    public void addConditionsTo(List<ConfigConditionAction> actions, String categoryKey, boolean advanced, ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.login": {
                if (Boolean.parseBoolean(settings.getValue(ConfigKey.SYSTEMPERMISSION_ENABLED))) break;
                ConditionGenerator conditionGenerator = new ConditionGenerator();
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.AUTHENTICATION_ALLOW_NEW_USER).equals().value(Boolean.TRUE);
                actions.add(conditionGenerator.visibleActionFor(configCondition, ConfigKey.AUTHENTICATION_ALLOW_NEW_USER.getKey() + ".attention"));
                break;
            }
            case "category.usersandgroups": {
                ConditionGenerator conditionGenerator = new ConditionGenerator();
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.SYSTEMPERMISSION_ENABLED).equals().value(Boolean.FALSE);
                actions.add(conditionGenerator.visibleActionFor(configCondition, ConfigKey.SYSTEMPERMISSION_ENABLED.getKey() + ".attention"));
                if (!LoginManager.isGuestAccount()) break;
                actions.add(conditionGenerator.visibleActionFor(configCondition, ConfigKey.GUEST_FULL_PERMISSIONS.getKey()));
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private ItemListConfigProperty a(boolean bl, @Nonnull ConfigStructureSettings configStructureSettings, boolean bl2) {
        AuthenticationProvider authenticationProvider;
        Object object4;
        Object object2;
        HashMap<String, String> hashMap;
        Object object3;
        DynamicExtensionManager dynamicExtensionManager = DynamicExtensionManager.getInstance();
        List<AuthenticationProvider> list2 = dynamicExtensionManager.get(AuthenticationProvider.class);
        Collections.sort(list2, new Comparator<AuthenticationProvider>(){

            public int a(AuthenticationProvider authenticationProvider, AuthenticationProvider authenticationProvider2) {
                return Integer.compare(authenticationProvider.getPriority(), authenticationProvider2.getPriority());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((AuthenticationProvider)object, (AuthenticationProvider)object2);
            }
        });
        HashMap<String, AuthenticationProvider> hashMap2 = new HashMap<String, AuthenticationProvider>();
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (AuthenticationProvider list3 : list2) {
            object3 = list3.name();
            hashMap2.put((String)object3, list3);
            if (list3 instanceof ActiveAuthenticationProvider) {
                if ("temp".equals(object3)) continue;
                arrayList2.add(object3);
                continue;
            }
            if (list3 instanceof SystemAuthenticationProvider) {
                arrayList.add(new LocalizedKey((String)object3, list3.getDisplayName(null)));
                continue;
            }
            String string = list3.getDisplayName(null);
            hashMap = CoreSecurityStructureProvider.a(null, object3, string, list3.isMultipleDescriptionSupported(), list3.hasAdditionalConfigurationAction(), bl, configStructureSettings);
            arrayList3.add(hashMap);
        }
        if (!arrayList.isEmpty()) {
            String string = ((LocalizedKey)arrayList.get(0)).getKey();
            String string2 = "logintype";
            object3 = this.translate(configStructureSettings, "authentication.system.logintype", new Object[0]);
            String string3 = this.translate(configStructureSettings, "authentication.system.logintype.tooltip", new Object[0]);
            hashMap = new SelectConfigProperty(-1, string2, "SimpleText", (String)object3, (Object)string, string3, (List<LocalizedKey>)arrayList);
            object2 = CoreSecurityStructureProvider.a(hashMap, "system", this.translate(configStructureSettings, "authentication.system", new Object[0]), false, true, bl, configStructureSettings);
            arrayList3.add(object2);
        }
        boolean bl3 = bl2 || configStructureSettings.getChangedValue(ConfigKey.AUTHENTICATION_SETTINGS.getKey()) != null;
        List<Map<String, String>> list = CoreSecurityStructureProvider.a(bl2 ? configStructureSettings.getOriginalValue(ConfigKey.AUTHENTICATION_SETTINGS) : configStructureSettings.getValue(ConfigKey.AUTHENTICATION_SETTINGS));
        for (Map map : list) {
            boolean bl4;
            block17: {
                block15: {
                    block16: {
                        hashMap = (String)map.get("provider");
                        for (Object object4 : arrayList3) {
                            if (((ConfigRowAction)object4).getEnableCondition() == null || ((ConfigRowAction)object4).getProperties() == null || !Objects.equals(hashMap, ((ConfigRowAction)object4).getEnableCondition().getParams()[1])) continue;
                            for (List<ConfigProperty> list3 : ((ConfigRowAction)object4).getProperties().values()) {
                                for (ConfigProperty configProperty : list3) {
                                    String string = configProperty.getKey();
                                    Object object5 = configProperty.getValue();
                                    if (object5 == null || map.containsKey(string)) continue;
                                    ((HashMap)map).put(string, object5);
                                }
                            }
                        }
                        object2 = (AuthenticationProvider)hashMap2.get(hashMap);
                        object4 = null;
                        bl4 = false;
                        if (object2 == null) break block15;
                        object4 = object2.getAuthenticationDescription(map, false, false);
                        if (object4 == null) {
                            object4 = object2.getAuthenticationDescription(map, true, false);
                        }
                        object2.transformGuiProperties((HashMap)map);
                        if (!arrayList2.contains(hashMap)) break block16;
                        map.put(NO_DELETE, "true");
                        arrayList2.remove(hashMap);
                        break block17;
                    }
                    if (!"master".equals(hashMap)) break block17;
                    bl3 = true;
                    break block17;
                }
                if ("system".equals(hashMap)) {
                    void var18_34;
                    bl4 = true;
                    String string = (String)map.get("logintype");
                    if (string == null && !arrayList.isEmpty()) {
                        String string4 = arrayList.get(0).getKey();
                        map.put("logintype", string4);
                    }
                    if (var18_34 != null) {
                        hashMap = var18_34;
                    }
                    for (AuthenticationProvider authenticationProvider2 : list2) {
                        if (!(authenticationProvider2 instanceof SystemAuthenticationProvider) || configStructureSettings.isFilter()) continue;
                        authenticationProvider2.transformGuiProperties((HashMap)map);
                        if (!Objects.equals(authenticationProvider2.name(), var18_34)) continue;
                        object2 = authenticationProvider2;
                        object4 = authenticationProvider2.getAuthenticationDescription(map, false, false);
                    }
                }
            }
            this.a(map, (AuthenticationProvider)object2, (String)((Object)hashMap), (AuthenticationDescription)object4, bl4, configStructureSettings);
        }
        object3 = arrayList2.iterator();
        while (object3.hasNext()) {
            String string = (String)object3.next();
            hashMap = (AuthenticationProvider)hashMap2.get(string);
            object2 = new HashMap();
            ((HashMap)object2).put("provider", string);
            object4 = hashMap.getAuthenticationDescription((Map<String, String>)object2, false, false);
            this.a((Map<String, String>)object2, (AuthenticationProvider)((Object)hashMap), string, (AuthenticationDescription)object4, false, configStructureSettings);
            ((HashMap)object2).put(NO_DELETE, "true");
            list.add((Map<String, String>)object2);
        }
        if (!bl3 && MasterLoginData.getLoginData().isPasswordSet() && (authenticationProvider = (AuthenticationProvider)hashMap2.get(object3 = "master")) != null) {
            hashMap = new HashMap<String, String>();
            hashMap.put("provider", (String)object3);
            hashMap.put("master.hidden", "true");
            this.a(hashMap, authenticationProvider, (String)object3, null, false, configStructureSettings);
            list.add(hashMap);
        }
        object3 = new ItemListConfigProperty(0, ConfigKey.AUTHENTICATION_SETTINGS.getKey(), "ItemListAuthentication", list, this.translate(configStructureSettings, "authentication.add", new Object[0]), arrayList3.toArray(new ConfigRowAction[0]));
        ((ItemListConfigProperty)object3).setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, NO_DELETE, "true"));
        return object3;
    }

    private void a(@Nonnull Map<String, String> map, AuthenticationProvider authenticationProvider, String string, AuthenticationDescription authenticationDescription, boolean bl, ConfigStructureSettings configStructureSettings) {
        String string2;
        if (authenticationDescription != null) {
            string2 = authenticationDescription.getDisplayName();
            map.put("color", authenticationDescription.getColor());
        } else {
            string2 = authenticationProvider != null ? authenticationProvider.getDisplayName(map) : string;
        }
        String string3 = null;
        if (bl) {
            string3 = string2;
            string2 = this.translate(configStructureSettings, "authentication.system", new Object[0]);
        }
        map.put("displayname", string2);
        if (string3 != null) {
            map.put("details", string3);
        }
    }

    @Nonnull
    private static ConfigRowAction a(ConfigProperty configProperty, @Nonnull String string, @Nonnull String string2, boolean bl, boolean bl2, boolean bl3, @Nonnull ConfigStructureSettings configStructureSettings) {
        Serializable serializable;
        Object object;
        String string3 = string + ".action";
        if (!bl2) {
            string3 = ACTION_PREFIX + string3;
        }
        DefaultConfigurationProvider defaultConfigurationProvider = new DefaultConfigurationProvider();
        HashSet<ConfigProperty> hashSet = new HashSet<ConfigProperty>();
        for (ConfigStructureProvider object32 : defaultConfigurationProvider.getStructureProviders()) {
            object32.addPropertiesTo(hashSet, string3, bl3, configStructureSettings);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        if (configProperty != null) {
            arrayList.add(configProperty);
        }
        Collections.sort(arrayList);
        ArrayList<ConfigConditionAction> arrayList2 = new ArrayList<ConfigConditionAction>();
        for (ConfigStructureProvider configStructureProvider : defaultConfigurationProvider.getStructureProviders()) {
            configStructureProvider.addConditionsTo(arrayList2, string3, bl3, configStructureSettings);
        }
        ConfigAction configAction = new ConfigAction(string3, string2);
        ConfigCondition configCondition = new ConfigCondition(ConfigCondition.Operation.Equals, "provider", string);
        Object object2 = LOGIN_HELP;
        HelpAdminBackdoor helpAdminBackdoor = ServerPluginManager.getInstance().getOptionalInstance(HelpAdminBackdoor.class);
        if (helpAdminBackdoor != null && !configStructureSettings.isFilter()) {
            object = "login-" + string;
            serializable = helpAdminBackdoor.getHelpPageForKey(configStructureSettings.getLocale(), (String)object);
            if (serializable != null) {
                object2 = object;
            }
        }
        object = new ConfigCategory(0, string3, string2, (String)object2);
        serializable = new ArrayList();
        ((ArrayList)serializable).add(new ConfigPropertyGroup(0, string3));
        HashMap<String, List<ConfigProperty>> hashMap = new HashMap<String, List<ConfigProperty>>();
        hashMap.put(string3, arrayList);
        arrayList.add(new ConfigProperty(0, "provider", "Hidden", null, string, null, null));
        ConfigRowAction configRowAction = !bl2 ? new ConfigRowAction(configAction, configCondition, null, null, null, null) : new ConfigRowAction(configAction, configCondition, (ConfigCategory)object, (ArrayList<ConfigPropertyGroup>)serializable, hashMap, arrayList2);
        configRowAction.setAddMultipleEntriesAllowed(bl);
        return configRowAction;
    }

    @Override
    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        switch (actionKey) {
            case "action.resetauthgroups": {
                for (UserGroupInfo userGroupInfo : UserGroupManager.getRecoveryEnabledInstance().getAllGroups()) {
                    if (!userGroupInfo.isAuthenticationGroup()) continue;
                    for (GUID gUID : userGroupInfo.getMemberIDs()) {
                        UserManager.getRecoveryEnabledInstance().clearUserAuthGroupNames(gUID);
                        UserManager.getRecoveryEnabledInstance().deleteBinaryData(gUID, BaseUserManager.ROLES_KEY);
                        try {
                            List<StayLoggedInSession> list = StayLoggedInHandler.getSessions(gUID, UserManager.getRecoveryEnabledInstance());
                            StayLoggedInHandler.deleteSessions(gUID, list);
                            Collection<HttpSession> collection = ExpandableHttpSessionListener.getActiveSessions();
                            for (HttpSession httpSession : collection) {
                                LoginProcessor loginProcessor = LoginManager.getLoginProcessor(httpSession);
                                if (loginProcessor == null || !gUID.equals(loginProcessor.getUserAccountID())) continue;
                                httpSession.invalidate();
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "action.resetauthgroups.success", new Object[0]), (String)null));
                ForkJoinPool.commonPool().execute(() -> StayLoggedInHandler.deleteAllStayLoggedInSessions());
                return;
            }
        }
        if (actionKey.startsWith(ACTION_PREFIX)) {
            Object object = DynamicExtensionManager.getInstance().get(AuthenticationProvider.class);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AuthenticationProvider authenticationProvider = (AuthenticationProvider)iterator.next();
                if (authenticationProvider.hasAdditionalConfigurationAction()) continue;
                if (actionKey.equals(ACTION_PREFIX + authenticationProvider.name() + ".action.ok")) {
                    List<Map<String, String>> list = CoreSecurityStructureProvider.a(settings.getValue(ConfigKey.AUTHENTICATION_SETTINGS));
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("provider", authenticationProvider.name());
                    list.add(hashMap);
                    settings.getValues().put(ConfigKey.AUTHENTICATION_SETTINGS.getKey(), new Json().toJson(list));
                    return;
                }
                if (!actionKey.equals(ACTION_PREFIX + authenticationProvider.name() + ".action")) continue;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Reload, "", actionKey + ".ok"));
                return;
            }
        }
        super.action(actionKey, messages, settings);
    }

    @Override
    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        Object object;
        Object object2;
        List<Map<String, String>> list;
        if (CATEGORY_LOGIN.equals(categoryKey)) {
            list = CoreSecurityStructureProvider.a(settings.getValue(ConfigKey.AUTHENTICATION_SETTINGS));
            if (list.isEmpty()) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, ConfigKey.AUTHENTICATION_SETTINGS.getKey() + ".empty", new Object[0]), ConfigKey.AUTHENTICATION_SETTINGS));
            } else {
                object2 = new HashSet();
                for (Map object3 : list) {
                    String string = (String)object3.get("logintype");
                    if (string == null || ((HashSet)object2).add(string)) continue;
                    String string2 = (String)object3.get("displayname");
                    if (string2 == null) {
                        string2 = string;
                    }
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "authentication.duplicate.logintype", string2), ConfigKey.AUTHENTICATION_SETTINGS));
                    break;
                }
                if (!Boolean.parseBoolean(settings.getValue(ConfigKey.SYSTEMPERMISSION_ENABLED))) {
                    object = settings.getChangedValue(ConfigKey.AUTHENTICATION_ALLOW_NEW_USER.getKey());
                    String bl = settings.getOriginalValue(ConfigKey.AUTHENTICATION_ALLOW_NEW_USER);
                    if (object != null && Boolean.parseBoolean((String)object) && !Boolean.parseBoolean(bl)) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "authentication.allowNewUser.warning", new Object[0]), ConfigKey.AUTHENTICATION_ALLOW_NEW_USER));
                    }
                }
            }
        }
        if (CATEGORY_USERS_AND_GROUPS.equals(categoryKey)) {
            list = ConfigKey.SYSTEMPERMISSION_ENABLED.getKey();
            object2 = settings.getChangedValue((String)((Object)list));
            object = settings.getOriginalValue(ConfigKey.SYSTEMPERMISSION_ENABLED);
            if (object2 != null && Boolean.parseBoolean((String)object2) && !Boolean.parseBoolean((String)object) && settings.isCurrentConfigurationSelected()) {
                settings.getConfiguration().put((String)((Object)list), (String)object2);
                boolean bl = SystemPermissionChecker.checkAccess(Permission.CONFIGURATION);
                settings.getConfiguration().put((String)((Object)list), (String)object);
                if (!bl) {
                    UserGroupManager.getInstance().addUserToGroup(UserManager.getInstance().getCurrentUserAccountID(), UsersAndGroups.GROUPID_ADMIN, new MembershipType[0]);
                }
            }
            if (object2 != null && !Boolean.parseBoolean((String)object2) && Boolean.parseBoolean((String)object)) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "systempermission.enabled.attention.warning", new Object[0]), ConfigKey.AUTHENTICATION_SETTINGS));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "authentication.settings": {
                Object object;
                List<Map<String, String>> list = Collections.unmodifiableList(CoreSecurityStructureProvider.a(settings.getOriginalValue(ConfigKey.AUTHENTICATION_SETTINGS)));
                ArrayList arrayList = (ArrayList)this.a(true, settings, true).getValue();
                List<Map<String, String>> list2 = CoreSecurityStructureProvider.a(value);
                DynamicExtensionManager dynamicExtensionManager = DynamicExtensionManager.getInstance();
                List<AuthenticationProvider> list3 = dynamicExtensionManager.get(AuthenticationProvider.class);
                Configuration configuration = settings.getConfiguration();
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = LoginManager.isGuestAccount();
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    void object2;
                    object = list2.get(i2);
                    int n2 = arrayList.indexOf(object);
                    String string = object.get("provider");
                    if (n2 >= 0 && n2 < list.size()) {
                        Map<String, String> map = list.get(n2);
                    } else {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if ("system".equals(string)) {
                            for (AuthenticationProvider authenticationProvider : list3) {
                                if (!(authenticationProvider instanceof SystemAuthenticationProvider)) continue;
                                hashMap.putAll(authenticationProvider.applySettings((Map<String, String>)object, configuration, list));
                            }
                            hashMap.put("logintype", object.get("logintype"));
                        } else {
                            for (AuthenticationProvider authenticationProvider : list3) {
                                if (!Objects.equals(authenticationProvider.name(), string)) continue;
                                hashMap.putAll(authenticationProvider.applySettings((Map<String, String>)object, configuration, list));
                                break;
                            }
                        }
                        hashMap.put("provider", string);
                    }
                    bl |= Objects.equals(string, "guest");
                    bl2 |= Objects.equals(string, "master");
                    list2.set(i2, (Map<String, String>)object2);
                }
                value = new Json().toJson(list2);
                settings.save(ConfigKey.AUTHENTICATION_SETTINGS, value);
                if (bl) {
                    new AnonymousLoginProcessor(){
                        {
                            this.getOrCreateUserAccount("guest");
                        }
                    };
                }
                if (bl2) {
                    new AnonymousLoginProcessor(){
                        {
                            this.getOrCreateUserAccount("Master");
                        }

                        @Override
                        @Nonnull
                        public String getLoginSource() {
                            return "master";
                        }

                        @Override
                        public UserAccountType getUserAccountType() {
                            return UserAccountType.Administrator;
                        }
                    };
                } else if (settings.isCurrentConfigurationSelected()) {
                    MasterLoginData.getLoginData().setPassword(null);
                } else {
                    settings.save(ConfigKey.MASTER_PASSWORD, null);
                }
                if (bl3 && !bl) {
                    for (HttpSession httpSession : ExpandableHttpSessionListener.getActiveSessions()) {
                        object = LoginManager.getLoginProcessor(httpSession);
                        if (object == null || ((LoginProcessor)object).getLoginSource() != "guest") continue;
                        httpSession.invalidate();
                    }
                }
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }

    @Nonnull
    private static List<Map<String, String>> a(String string) {
        return (List)new Json().fromJson(string, (Type)new JsonParameterizedType((Type)((Object)ArrayList.class), new Type[]{HashMap.class}));
    }
}

