/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import java.io.InputStream;
import javax.annotation.Nonnull;

@InternalApi
public class FastByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public FastByteArrayInputStream(byte @Nonnull [] buf) {
        this(buf, 0, buf.length);
    }

    public FastByteArrayInputStream(byte @Nonnull [] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
        this.mark = offset;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        if (off < 0 || len < 0 || len > b2.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int n2 = this.count - this.pos;
        if (len > n2) {
            len = n2;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b2, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n2) {
        long l2 = this.count - this.pos;
        if (n2 < l2) {
            l2 = n2 < 0L ? 0L : n2;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
    }
}

