/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.core;

import com.inet.annotations.InternalApi;
import com.inet.http.utils.Browser;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import java.io.InputStream;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public final class OS
extends Enum<OS> {
    public static final /* enum */ OS Windows = new OS();
    public static final /* enum */ OS Linux = new OS();
    public static final /* enum */ OS Mac = new OS();
    public static final /* enum */ OS Solaris = new OS();
    public static final /* enum */ OS Android = new OS();
    public static final /* enum */ OS iPhone = new OS();
    public static final /* enum */ OS iPad = new OS();
    public static final /* enum */ OS Unknown = new OS();
    public static final String OS_NAME;
    private static OS a;
    private static Boolean b;
    private static final /* synthetic */ OS[] c;

    public static OS[] values() {
        return (OS[])c.clone();
    }

    public static OS valueOf(String name) {
        return Enum.valueOf(OS.class, name);
    }

    public String getDisplayName() {
        return Browser.I18N.getMsg("os." + this.name().toLowerCase(), new Object[0]);
    }

    @Nonnull
    public static OS parseOS(@Nullable String str) {
        if (str == null) {
            return Unknown;
        }
        if ((str = str.toLowerCase()).contains("windows")) {
            return Windows;
        }
        if (str.contains("android")) {
            return Android;
        }
        if (str.contains("linux")) {
            return Linux;
        }
        if (str.contains("sunos") || str.contains("solaris")) {
            return Solaris;
        }
        if (str.contains("iphone")) {
            return iPhone;
        }
        if (str.contains("ipad")) {
            return iPad;
        }
        if (str.contains("mac")) {
            return Mac;
        }
        if (str.contains("microsoft-webdav-miniredir")) {
            return Windows;
        }
        return Unknown;
    }

    public static final boolean isMac() {
        return a == Mac;
    }

    public static final boolean isUnix() {
        return OS.isSolaris() || OS.isLinux();
    }

    public static final boolean isSolaris() {
        return a == Solaris;
    }

    public static final boolean isLinux() {
        return a == Linux || a == Android;
    }

    public static final boolean isWindows() {
        return a == Windows;
    }

    public static final boolean isMuslLibrary() {
        if (b == null) {
            if (a == Linux) {
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder("ldd", "/bin/ls");
                    Process process = processBuilder.start();
                    InputStream inputStream = process.getInputStream();
                    process.waitFor(5L, TimeUnit.SECONDS);
                    String string = IOFunctions.readAsciiString(inputStream);
                    LogManager.getConfigLogger().debug(string);
                    b = string.contains("musl-");
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().debug(throwable);
                    b = Boolean.FALSE;
                }
            } else {
                b = Boolean.FALSE;
            }
        }
        return b;
    }

    private static /* synthetic */ OS[] b() {
        return new OS[]{Windows, Linux, Mac, Solaris, Android, iPhone, iPad, Unknown};
    }

    static {
        c = OS.b();
        OS_NAME = AccessController.doPrivileged(() -> System.getProperty("os.name"));
        a = OS.parseOS(OS_NAME);
    }
}

