/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics.buffered;

import com.inet.annotations.InternalApi;
import com.inet.graphics.buffered.BufferedGraphics2D;
import com.inet.graphics.buffered.BufferedGraphicsCommand;
import com.inet.graphics.buffered.FontMetricsProvider;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@InternalApi
public class PaintTransformingBufferedGraphics
extends BufferedGraphics2D {
    private int a = 512;
    private double b = 4.0;
    private int c = 0;
    private Map<Paint, a> d = new IdentityHashMap<Paint, a>();
    private Set<Class<? extends Paint>> e;
    private a f;
    private Rectangle g;
    private Paint h;

    public PaintTransformingBufferedGraphics() {
    }

    public PaintTransformingBufferedGraphics(FontMetricsProvider capabilities, Set<Class<? extends Paint>> knownClasses) {
        super(capabilities);
        this.e = knownClasses;
    }

    public void setScaleFactor(double scaleFactor) {
        this.b = scaleFactor;
    }

    public void setMaxTextureSize(int maxTextureSize) {
        this.a = maxTextureSize;
    }

    private void a(Shape shape) {
        Stroke stroke = this.getStroke();
        if (stroke == null || this.g == null) {
            return;
        }
        this.g.add(stroke.createStrokedShape(shape).getBounds());
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null || paint instanceof Color || paint instanceof TexturePaint || this.e == null || this.e.contains(paint.getClass())) {
            this.g = null;
            this.h = null;
            super.setPaint(paint);
            return;
        }
        a a2 = this.d.get(paint);
        if (a2 == null) {
            a2 = new a();
            this.d.put(paint, a2);
        }
        int n2 = this.getGraphicsProvider().getList().size();
        a2.b.add(n2);
        this.g = a2.a;
        this.f = a2;
        this.h = paint;
        super.setPaint(new b());
    }

    @Override
    public Paint getPaint() {
        if (this.g == null || this.h == null) {
            return super.getPaint();
        }
        return this.h;
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        super.fillRect(x, y, width, height);
        if (this.g != null) {
            this.g.add(x, y);
            this.g.add(x + width, y + height);
        }
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        super.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        if (this.g != null) {
            this.g.add(x, y);
            this.g.add(x + width, y + height);
        }
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        super.fillOval(x, y, width, height);
        if (this.g != null) {
            this.g.add(x, y);
            this.g.add(x + width, y + height);
        }
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        super.fillPolygon(xPoints, yPoints, nPoints);
        if (this.g != null) {
            for (int i2 = 0; i2 < nPoints; ++i2) {
                this.g.add(xPoints[i2], yPoints[i2]);
            }
        }
    }

    @Override
    public void fillPolygon(Polygon p2) {
        super.fillPolygon(p2);
        if (this.g != null) {
            this.g.add(p2.getBounds());
        }
    }

    @Override
    public void fill(Shape s) {
        super.fill(s);
        if (this.g != null) {
            this.g.add(s.getBounds());
            this.f.a(this);
        }
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        super.fillArc(x, y, width, height, startAngle, arcAngle);
        if (this.g != null) {
            this.g.add(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2).getBounds());
        }
    }

    @Override
    public void draw(Shape s) {
        super.draw(s);
        if (this.g != null) {
            this.a(s);
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        super.drawArc(x, y, width, height, startAngle, arcAngle);
        if (this.g != null) {
            this.a(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        super.drawLine(x1, y1, x2, y2);
        if (this.g != null) {
            this.a(new Line2D.Float(x1, y1, x2, y2));
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g2, float x, float y) {
        super.drawGlyphVector(g2, x, y);
        if (this.g != null) {
            this.g.add(g2.getVisualBounds());
        }
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        super.drawOval(x, y, width, height);
        if (this.g != null) {
            this.a(new Ellipse2D.Double(x, y, width, height));
        }
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        super.drawPolygon(xPoints, yPoints, nPoints);
        if (this.g != null) {
            this.a(new Polygon(xPoints, yPoints, nPoints));
        }
    }

    @Override
    public void drawPolygon(Polygon p2) {
        super.drawPolygon(p2);
        if (this.g != null) {
            this.a(p2);
        }
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        super.drawRect(x, y, width, height);
        if (this.g != null) {
            this.a(new Rectangle(x, y, width, height));
        }
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        super.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        if (this.g != null) {
            this.a(new Rectangle(x, y, width, height));
        }
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        super.drawPolyline(xPoints, yPoints, nPoints);
        if (this.g != null) {
            this.a(new Polygon(xPoints, yPoints, nPoints));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        DirectColorModel directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        List<BufferedGraphicsCommand> list = this.getGraphicsProvider().getList();
        for (Map.Entry<Paint, a> entry : this.d.entrySet()) {
            BufferedGraphicsCommand.MethodNames methodNames;
            Paint paint;
            Paint paint2 = entry.getKey();
            a a2 = entry.getValue();
            Rectangle rectangle = a2.a;
            if (rectangle.isEmpty()) {
                paint = Color.BLACK;
                methodNames = BufferedGraphicsCommand.MethodNames.SET_COLOR;
            } else {
                double d2;
                double d3;
                if (this.c > 0) {
                    rectangle = new Rectangle(rectangle.x - this.c, rectangle.y - this.c, rectangle.width + 2 * this.c, rectangle.height + 2 * this.c);
                }
                if ((d3 = Math.max((d2 = a2.c * this.b) * (double)rectangle.width, d2 * (double)rectangle.height)) > (double)this.a) {
                    d2 *= (double)this.a / d3;
                }
                AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, d2);
                Rectangle rectangle2 = affineTransform.createTransformedShape(rectangle).getBounds();
                PaintContext paintContext = paint2.createContext(directColorModel, rectangle2, rectangle, affineTransform, this.getRenderingHints());
                Raster raster = paintContext.getRaster(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                WritableRaster writableRaster = raster.createCompatibleWritableRaster();
                writableRaster.setDataElements(-raster.getMinX(), -raster.getMinY(), raster);
                BufferedImage bufferedImage = new BufferedImage(paintContext.getColorModel(), writableRaster, false, null);
                paint = new TexturePaint(bufferedImage, rectangle);
                methodNames = BufferedGraphicsCommand.MethodNames.SET_TEXTURE_PAINT;
            }
            for (Integer n2 : a2.b) {
                BufferedGraphicsCommand bufferedGraphicsCommand = list.get(n2);
                bufferedGraphicsCommand.setMethod(methodNames);
                bufferedGraphicsCommand.setParameter(0, paint);
            }
        }
    }

    static class a {
        private Rectangle a = new Rectangle(0, 0, -1, -1);
        private ArrayList<Integer> b = new ArrayList();
        private double c = 1.0;

        a() {
        }

        void a(BufferedGraphics2D bufferedGraphics2D) {
            AffineTransform affineTransform = bufferedGraphics2D.getTransform();
            if (affineTransform.getScaleX() > this.c) {
                this.c = affineTransform.getScaleX();
            }
            if (affineTransform.getScaleY() > this.c) {
                this.c = affineTransform.getScaleY();
            }
        }
    }

    private static class b
    implements Paint,
    Serializable {
        private b() {
        }

        @Override
        public int getTransparency() {
            return 0;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
            return Color.WHITE.createContext(cm, r, r2d, xform, hints);
        }
    }
}

