/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jeuclid.converter.BatikDetector;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.converter.FreeHepDetector;
import net.sourceforge.jeuclid.converter.ImageIODetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConverterRegistry {
    private static ConverterRegistry converterRegisty;
    private final Map<String, ConverterPlugin> mimetype2converter = new HashMap<String, ConverterPlugin>();
    private final Map<String, String> mimetype2suffix = new HashMap<String, String>();
    private final Map<String, String> suffix2mimetype = new HashMap<String, String>();

    private ConverterRegistry() {
    }

    public static ConverterRegistry getRegisty() {
        if (converterRegisty == null) {
            converterRegisty = new ConverterRegistry();
            ImageIODetector.detectConversionPlugins(converterRegisty);
            BatikDetector.detectConversionPlugins(converterRegisty);
            FreeHepDetector.detectConversionPlugins(converterRegisty);
        }
        return converterRegisty;
    }

    public Set<String> getAvailableOutfileTypes() {
        return this.mimetype2converter.keySet();
    }

    public Set<String> getAvailableExtensions() {
        HashSet<String> extensions = new HashSet<String>();
        for (Map.Entry<String, String> e : this.suffix2mimetype.entrySet()) {
            if (!this.mimetype2converter.containsKey(e.getValue())) continue;
            extensions.add(e.getKey());
        }
        return extensions;
    }

    public String getSuffixForMimeType(String mimeType) {
        return this.mimetype2suffix.get(mimeType.toLowerCase(Locale.ENGLISH));
    }

    public String getMimeTypeForSuffix(String suffix) {
        return this.suffix2mimetype.get(suffix.toLowerCase(Locale.ENGLISH));
    }

    public void registerMimeTypeAndSuffix(String mimeType, String suffix, boolean primary) {
        String lMimeType = mimeType.toLowerCase(Locale.ENGLISH);
        String lSuffix = suffix.toLowerCase(Locale.ENGLISH);
        if (primary || !this.suffix2mimetype.containsKey(lSuffix)) {
            this.suffix2mimetype.put(lSuffix, lMimeType);
        }
        if (primary || !this.mimetype2suffix.containsKey(lMimeType)) {
            this.mimetype2suffix.put(lMimeType, lSuffix);
        }
    }

    public void registerConverter(String mimeType, ConverterPlugin converter, boolean primary) {
        if (primary || !this.mimetype2converter.containsKey(mimeType)) {
            this.mimetype2converter.put(mimeType, converter);
        }
    }

    public ConverterPlugin getConverter(String mimeType) {
        return this.mimetype2converter.get(mimeType.toLowerCase(Locale.ENGLISH));
    }
}

