/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.viewer.FallbackFormatter;
import com.inet.viewer.PromptValue;
import com.inet.viewer.ViewerException;
import com.inet.viewer.i18n.a;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;

@JsonData
@PublicApi
class SinglePromptValue
extends PromptValue {
    private static final long serialVersionUID = 514213561173096L;
    private Object value;

    public SinglePromptValue(int type) {
        super(type);
    }

    public SinglePromptValue(Object value, String description, int type) {
        super(description, type);
        this.value = value;
    }

    SinglePromptValue(int type, String valueString) throws Exception {
        super("", type);
        this.parseValue(valueString);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object defaultValue) {
        this.value = defaultValue;
    }

    @Override
    void initValue() {
        Calendar calendar = Calendar.getInstance();
        switch (this.getType()) {
            case 6: 
            case 7: {
                this.value = new Double(0.0);
                break;
            }
            case 8: {
                this.value = Boolean.FALSE;
                break;
            }
            case 11: {
                this.value = "";
                break;
            }
            case 14: {
                break;
            }
            case 10: {
                calendar.set(1, 1970);
                calendar.set(2, 0);
                calendar.set(5, 1);
                calendar.set(14, 0);
                this.value = new Time(calendar.getTime().getTime());
                break;
            }
            case 9: 
            case 15: {
                this.value = calendar;
            }
        }
    }

    void parseValue(String valueString) throws Exception {
        if (this.getType() != 11 && (valueString == null || valueString.length() == 0)) {
            this.value = null;
            return;
        }
        String string = "";
        try {
            switch (this.getType()) {
                case 6: 
                case 7: {
                    string = a.a("prompt.type_number");
                    this.value = new Double(NUMBERFORMAT.parse(valueString).doubleValue());
                    break;
                }
                case 8: {
                    string = a.a("prompt.type_boolean");
                    this.value = Boolean.valueOf(valueString);
                    break;
                }
                case 11: {
                    string = a.a("prompt.type_string");
                    this.value = valueString;
                    break;
                }
                case 14: {
                    string = a.a("prompt.type_binary");
                    break;
                }
                case 9: {
                    string = a.a("prompt.type_date");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)DATEFORMAT.parseObject(valueString));
                    this.setValue(calendar);
                    break;
                }
                case 10: {
                    string = a.a("prompt.type_time");
                    Date date = (Date)TIMEFORMAT.parseObject(valueString);
                    Time time = new Time(date.getTime());
                    this.setValue(time);
                    break;
                }
                case 15: {
                    string = a.a("prompt.type_datetime");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)DATETIMEFORMAT.parseObject(valueString));
                    this.setValue(calendar);
                }
            }
        }
        catch (Exception exception) {
            throw new ViewerException(a.a("prompt.invalid_value") + ". " + a.a("prompt.expected_type", string), exception);
        }
    }

    @Override
    public String getValueString() {
        NumberFormat numberFormat;
        if (this.getValue() == null) {
            return "";
        }
        switch (this.getType() % 128) {
            case 6: 
            case 7: {
                numberFormat = PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                Format format = PromptValue.DATEFORMAT;
                return format.format(((Calendar)this.getValue()).getTime());
            }
            case 15: {
                Format format = PromptValue.DATETIMEFORMAT;
                if (((Calendar)this.getValue()).get(13) == 0) {
                    ((FallbackFormatter)PromptValue.DATETIMEFORMAT).setOutputFormat(PromptValue.DATETIME_FOUR_DIGIT_YEAR_NO_SECONDS);
                } else {
                    ((FallbackFormatter)PromptValue.DATETIMEFORMAT).setOutputFormat(PromptValue.DATETIME_FOUR_DIGIT_YEAR_WITH_SECONDS);
                }
                return format.format(((Calendar)this.getValue()).getTime());
            }
            case 10: {
                Format format = PromptValue.TIMEFORMAT;
                return format.format(this.getValue());
            }
            case 8: {
                if (this.value instanceof Boolean) {
                    if (((Boolean)this.value).booleanValue()) {
                        return a.a("prompt.true");
                    }
                    return a.a("prompt.false");
                }
                return a.a("prompt.false");
            }
            default: {
                return this.value.toString();
            }
        }
        return numberFormat.format(this.getValue());
    }

    @Override
    public String getStringRepresentation() {
        if (this.getValue() == null) {
            if (this.getType() == 11) {
                return "''";
            }
            return "";
        }
        String string = "";
        switch (this.getType()) {
            case 14: {
                return String.valueOf(this.value);
            }
            case 9: {
                Date date = ((Calendar)this.getValue()).getTime();
                string = "Date(" + (date.getYear() + 1900) + "," + (date.getMonth() + 1) + "," + date.getDate() + ")";
                break;
            }
            case 15: {
                Date date = ((Calendar)this.getValue()).getTime();
                string = "DateTime(" + (date.getYear() + 1900) + "," + (date.getMonth() + 1) + "," + date.getDate() + "," + date.getHours() + "," + date.getMinutes() + "," + date.getSeconds() + ")";
                break;
            }
            case 10: {
                Time time = (Time)this.getValue();
                string = "Time(" + time.getHours() + "," + time.getMinutes() + "," + time.getSeconds() + ")";
                break;
            }
            case 8: {
                Boolean bl = (Boolean)this.getValue();
                string = bl.toString();
                break;
            }
            case 6: 
            case 7: {
                Double d2 = (Double)this.getValue();
                if (d2 == Double.POSITIVE_INFINITY) {
                    string = "'<'";
                    break;
                }
                if (d2 == Double.NEGATIVE_INFINITY) {
                    string = "'>'";
                    break;
                }
                string = d2.toString();
                break;
            }
            case 11: {
                String string2 = this.getValueString();
                string2 = string2.replaceAll("'", "''");
                string = "'" + string2 + "'";
            }
        }
        return string;
    }

    @Override
    public Object getSQLTypedValue() {
        if (this.value == null) {
            return this.value;
        }
        switch (this.getType()) {
            case 9: {
                return ((Calendar)this.value).getTime();
            }
            case 15: {
                return new Timestamp(((Calendar)this.value).getTime().getTime());
            }
        }
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SinglePromptValue)) {
            return false;
        }
        SinglePromptValue singlePromptValue = (SinglePromptValue)obj;
        boolean bl = false;
        bl = singlePromptValue.value == null ? this.value == null : singlePromptValue.value.equals(this.value);
        boolean bl2 = false;
        String string = singlePromptValue.getDescription();
        bl2 = string == null ? this.getDescription() == null : string.equals(this.getDescription());
        return bl && bl2;
    }
}

