/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.error.HasErrorCode;
import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.SwingViewerContext;
import com.inet.viewer.SwingViewerUtils;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.i18n.a;
import com.inet.viewer.r;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;

@InternalApi
public final class JErrorDialog
extends JDialog
implements ActionListener {
    private JButton a;
    private JButton b;
    private JPanel c;
    private Properties d;
    private Component e;
    private JScrollPane f;
    private ViewerContext g;
    private String h;
    private r i;
    private r j;

    private JErrorDialog(ViewerContext context, Component parent, Frame frame, String title, Throwable th) {
        super(frame, title, true);
        this.g = context;
        this.e = parent;
        this.setName("errordialog");
        this.a(th);
    }

    private JErrorDialog(ViewerContext context, Component parent, Dialog dialog, String title, Throwable th) {
        super(dialog, title, true);
        this.g = context;
        this.e = parent;
        this.a(th);
    }

    private JErrorDialog(ViewerContext context, Component parent, Frame frame, String title, String message, String detailData) {
        super(frame, title, true);
        this.g = context;
        this.e = parent;
        this.setName("errordialog");
        this.a(0, message, detailData);
    }

    private JErrorDialog(ViewerContext context, Component parent, Dialog dialog, String title, String message, String detailData) {
        super(dialog, title, true);
        this.g = context;
        this.e = parent;
        this.a(0, message, detailData);
    }

    public static void showError(Component parent, String title, Throwable th) {
        ViewerContext viewerContext = parent instanceof SwingReportViewer ? ((SwingReportViewer)parent).getViewerContext() : new SwingViewerContext(parent);
        Window window = SwingViewerUtils.getParentWindow(parent);
        if (window instanceof Frame) {
            new JErrorDialog(viewerContext, parent, (Frame)window, title, th).setVisible(true);
        } else {
            new JErrorDialog(viewerContext, parent, (Dialog)window, title, th).setVisible(true);
        }
    }

    public static void showError(Component parent, Throwable th) {
        JErrorDialog.showError(parent, com.inet.viewer.i18n.a.a("errordialog.error"), th);
    }

    public static void showError(Component parent, String title, String message, String detailData) {
        ViewerContext viewerContext = parent instanceof SwingReportViewer ? ((SwingReportViewer)parent).getViewerContext() : new SwingViewerContext(parent);
        Window window = SwingViewerUtils.getParentWindow(parent);
        if (window instanceof Frame) {
            new JErrorDialog(viewerContext, parent, (Frame)window, title, message, detailData).setVisible(true);
        } else {
            new JErrorDialog(viewerContext, parent, (Dialog)window, title, message, detailData).setVisible(true);
        }
    }

    public static void showError(Component parent, String message, String detailData) {
        JErrorDialog.showError(parent, com.inet.viewer.i18n.a.a("errordialog.error"), message, detailData);
    }

    private void a(Throwable throwable) {
        this.setFocusable(true);
        int n2 = throwable instanceof HasErrorCode ? ((HasErrorCode)((Object)throwable)).getErrorCode() : 0;
        if (throwable instanceof ViewerException) {
            String string;
            ViewerException viewerException = (ViewerException)throwable;
            if (viewerException.getCause() != null) {
                throwable = viewerException.getCause();
            }
            if ((string = viewerException.stacktrace) == null) {
                string = JErrorDialog.b(throwable);
            }
            this.h = this.a(viewerException.getSupportEmail());
            this.a(n2, ViewerException.getErrorMessage(viewerException), string);
            this.d.setProperty("version", this.a(viewerException.srvVersion));
            this.d.setProperty("format", this.a(viewerException.format));
            this.d.setProperty("server_java_version", this.a(viewerException.srvJVM));
            this.d.setProperty("os", this.a(viewerException.srvOS));
            this.d.setProperty("cache", String.valueOf(viewerException.srvCache));
        } else {
            this.a(n2, ViewerException.getErrorMessage(throwable), JErrorDialog.b(throwable));
        }
        ViewerUtils.printStackTrace(throwable);
    }

    private String a(String string) {
        return string == null ? "" : string;
    }

    private static final String b(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private final void a(int n2, String string, String string2) {
        JComponent jComponent;
        this.setDefaultCloseOperation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(keyStroke, "escape");
        this.getRootPane().getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JErrorDialog.this.dispose();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        Insets insets = new Insets(8, 8, 0, 8);
        this.d = new Properties();
        if (string != null) {
            this.d.setProperty("message", string);
        }
        if (string2 != null) {
            this.d.setProperty("stacktrace", string2);
        }
        string = this.a(string);
        string2 = this.a(string2);
        JLabel jLabel = new JLabel();
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        if (icon != null && icon.getIconHeight() > 0 && icon.getIconWidth() > 0) {
            jLabel = new JLabel(icon);
            container.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 3, 0.0, 0.0, 11, 0, insets, 0, 0));
        }
        if (n2 != 0) {
            this.d.setProperty("errnumber", String.valueOf(n2));
            container.add((Component)new JLabel(com.inet.viewer.i18n.a.a("errordialog.error") + ":"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            container.add((Component)new JLabel(String.valueOf(n2)), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        }
        container.add((Component)new JLabel(com.inet.viewer.i18n.a.a("description") + ":"), new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        if (string.startsWith("<html>")) {
            jComponent = new JEditorPane();
            ((JTextComponent)jComponent).setEditable(false);
            ((JEditorPane)jComponent).setContentType("text/html");
            jComponent.setPreferredSize(new Dimension(500, 180));
            ((JEditorPane)jComponent).addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e2) {
                    if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            JErrorDialog.this.g.showUrl(e2.getURL().toString(), null);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ViewerUtils.printStackTrace(malformedURLException);
                        }
                    }
                }
            });
            ((JTextComponent)jComponent).getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            ((JEditorPane)jComponent).setText(string);
            this.f = new JScrollPane(jComponent, 20, 31);
        } else {
            jComponent = new JTextArea();
            ((JTextArea)jComponent).setLineWrap(true);
            ((JTextArea)jComponent).setWrapStyleWord(true);
            ((JTextComponent)jComponent).setText(string);
            ((JTextComponent)jComponent).setEditable(false);
            jComponent.setBackground(jLabel.getBackground());
            ((JTextArea)jComponent).setRows(5);
            ((JTextArea)jComponent).setColumns(45);
            ((JTextArea)jComponent).setFont(UIManager.getFont("OptionPane.messageFont"));
            this.f = new JScrollPane(jComponent, 20, 31);
            this.f.setBorder(null);
        }
        container.add((Component)this.f, new GridBagConstraints(1, 4, 3, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(2, 8, 8));
        container.add((Component)jComponent, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 13, 0, new Insets(0, 80, 0, 0), 0, 0));
        this.a = new JButton(com.inet.viewer.i18n.a.a("ok"));
        this.a.addActionListener(this);
        this.a.setRequestFocusEnabled(true);
        this.a.setName("lib.inet.ok");
        jComponent.add(this.a);
        this.getRootPane().setDefaultButton(this.a);
        this.b = new JButton(com.inet.viewer.i18n.a.a("errordialog.details") + " >>");
        this.b.addActionListener(this);
        this.b.setEnabled(string2.trim().length() > 0);
        jComponent.add(this.b);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("MONOSPACED", 0, jTextArea.getFont().getSize() - 2));
        jTextArea.setText(string2);
        jTextArea.setEditable(false);
        jTextArea.setBackground(null);
        jTextArea.setRows(7);
        jTextArea.setColumns(45);
        this.c = new JPanel();
        this.c.setLayout(new GridBagLayout());
        this.c.setVisible(false);
        container.add((Component)this.c, new GridBagConstraints(1, 6, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0));
        final JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
        this.c.add((Component)jScrollPane, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 8, 0), 0, 0));
        if (this.h != null && this.h.length() > 0) {
            this.i = new r(com.inet.viewer.i18n.a.a("errordialog.support"));
            this.i.a(this);
            this.c.add((Component)this.i, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.j = new r(com.inet.viewer.i18n.a.a("errordialog.more_info"));
        this.j.a(this);
        this.c.add((Component)this.j, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.e);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JErrorDialog.this.a.requestFocusInWindow();
                JErrorDialog.this.f.getVerticalScrollBar().setValue(0);
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            Object object = ev.getSource();
            if (object == this.a) {
                this.dispose();
            } else if (object == this.i) {
                StringBuilder stringBuilder = new StringBuilder("mailto:" + this.h + "?subject=");
                String string = this.d.getProperty("message", "");
                if (string.length() > 60) {
                    string = string.substring(0, 57) + "...";
                }
                stringBuilder.append(new URI("bla", string, null).getRawSchemeSpecificPart());
                stringBuilder.append("&body=");
                string = "<Your description>\r\n<Steps to reproduce error>\r\n\r\nThe following error occurred while running a report in the Viewer:\r\n" + this.d.getProperty("stacktrace", "");
                stringBuilder.append(new URI("bla", string, null).getRawSchemeSpecificPart());
                this.g.showUrl(stringBuilder.toString(), null);
                this.dispose();
            } else if (object == this.j) {
                int n2 = JOptionPane.showConfirmDialog(this, com.inet.viewer.i18n.a.a("errordialog.confirm"), com.inet.viewer.i18n.a.a("errordialog.error"), 0);
                if (n2 == 0) {
                    this.d.setProperty("client_java_version", System.getProperty("java.version") + "; " + System.getProperty("java.vm.name", "") + "; " + System.getProperty("java.vendor"));
                    this.d.setProperty("client_os", System.getProperty("os.name", "") + " " + System.getProperty("os.version", ""));
                    this.dispose();
                    this.g.showUrl("https://www.inetsoftware.de/external-services/error", this.d);
                }
            } else if (object == this.b) {
                GridBagLayout gridBagLayout = (GridBagLayout)this.getContentPane().getLayout();
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.f);
                if (this.c.isVisible()) {
                    this.b.setText(com.inet.viewer.i18n.a.a("errordialog.details") + " >>");
                    gridBagConstraints.weighty = 1.0;
                    this.c.setVisible(false);
                } else {
                    this.b.setText(com.inet.viewer.i18n.a.a("errordialog.details") + " <<");
                    gridBagConstraints.weighty = 0.0;
                    this.c.setVisible(true);
                }
                gridBagLayout.setConstraints(this.f, gridBagConstraints);
                this.pack();
            }
        }
        catch (Throwable throwable) {
            JErrorDialog.showError(this.e, throwable);
        }
    }
}

