/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.spi.searchlistener;

import com.inet.id.GUID;
import com.inet.persistence.Persistence;
import com.inet.persistence.spi.searchlistener.RegisterSearchListenerMatcherEvent;
import com.inet.persistence.spi.searchlistener.RegisterSearchListenerTokenEvent;
import com.inet.persistence.spi.searchlistener.SearchListenerManager;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.ListenerTokenMatcher;
import com.inet.search.index.SearchResultListener;
import com.inet.search.index.TagIndex;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchListenerContainer<ID> {
    private final Persistence persistence;
    private final SearchListenerManager manager;
    private final String indexTagID;
    private final SearchTag searchTag;
    private ConcurrentHashMap<Comparable<?>, List<SearchResultListener<ID>>> localListenTokens;
    private ConcurrentHashMap<ListenerTokenMatcher, List<SearchResultListener<ID>>> localListenMatcher;
    private ConcurrentHashMap<Comparable<?>, List<GUID>> cloudListenTokens;
    private ConcurrentHashMap<ListenerTokenMatcher, List<GUID>> cloudListenMatcher;

    public SearchListenerContainer(@Nonnull Persistence persistence, @Nonnull SearchListenerManager manager, @Nonnull String indexTagID, @Nonnull SearchTag searchTag) {
        this.persistence = persistence;
        this.manager = manager;
        this.indexTagID = indexTagID;
        this.searchTag = searchTag;
    }

    public void notifySearchResultListener(@Nullable Comparable<?> value) {
        try {
            Comparable<?> val;
            List<SearchResultListener<ID>> listeners2;
            if (this.localListenTokens != null && (listeners2 = this.localListenTokens.get(val = value == null ? TagIndex.NULL : value)) != null) {
                for (SearchResultListener<ID> listener : listeners2) {
                    listener.markPossibleChanged();
                }
            }
            if (value != null && this.localListenMatcher != null) {
                this.localListenMatcher.forEach((matcher, listeners) -> {
                    if (matcher.match(value)) {
                        for (SearchResultListener listener : listeners) {
                            listener.markPossibleChanged();
                        }
                    }
                });
            }
            if (this.cloudListenTokens != null && (listeners2 = this.cloudListenTokens.get(val = value == null ? TagIndex.NULL : value)) != null) {
                this.manager.notifyChangedListeners(listeners2);
            }
            if (value != null && this.cloudListenMatcher != null) {
                this.cloudListenMatcher.forEach((matcher, listeners) -> {
                    if (matcher.match(value)) {
                        this.manager.notifyChangedListeners((List<GUID>)listeners);
                    }
                });
            }
        }
        catch (Throwable th) {
            IndexSearchEngine.LOGGER.error((Object)("Invalid view matcher for " + this.indexTagID + ", index type: " + String.valueOf(this.searchTag.getDataType()) + ", value: " + String.valueOf(value)));
            IndexSearchEngine.LOGGER.error(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTokenChangedListener(@Nonnull Comparable<?> token, @Nonnull SearchResultListener<ID> listener, boolean add) {
        SearchListenerContainer searchListenerContainer = this;
        synchronized (searchListenerContainer) {
            List<SearchResultListener<ID>> listeners;
            if (this.localListenTokens == null) {
                this.localListenTokens = new ConcurrentHashMap();
            }
            if ((listeners = this.localListenTokens.get(token)) == null) {
                listeners = new CopyOnWriteArrayList<SearchResultListener<ID>>();
                this.localListenTokens.put(token, listeners);
            }
            if (add) {
                listeners.add(listener);
            } else {
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    this.localListenTokens.remove(token);
                }
            }
        }
        GUID listenerID = this.manager.getListenerID(listener);
        this.persistence.sendEvent((Object)new RegisterSearchListenerTokenEvent(this.indexTagID, listenerID, token, add));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCloudTokenChangedListener(@Nonnull RegisterSearchListenerTokenEvent event) {
        Comparable token = TagIndex.convertToken((Object)event.token, (SearchTag)this.searchTag);
        SearchListenerContainer searchListenerContainer = this;
        synchronized (searchListenerContainer) {
            List<GUID> listeners;
            if (this.cloudListenTokens == null) {
                this.cloudListenTokens = new ConcurrentHashMap();
            }
            if ((listeners = this.cloudListenTokens.get(token)) == null) {
                listeners = new CopyOnWriteArrayList<GUID>();
                this.cloudListenTokens.put(token, listeners);
            }
            if (event.add) {
                listeners.add(event.listenerID);
            } else {
                listeners.remove(event.listenerID);
                if (listeners.size() == 0) {
                    this.cloudListenTokens.remove(token);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMatcherChangedListener(@Nonnull ListenerTokenMatcher matcher, @Nonnull SearchResultListener<ID> listener, boolean add) {
        SearchListenerContainer searchListenerContainer = this;
        synchronized (searchListenerContainer) {
            List<SearchResultListener<ID>> listeners;
            if (this.localListenMatcher == null) {
                this.localListenMatcher = new ConcurrentHashMap();
            }
            if ((listeners = this.localListenMatcher.get(matcher)) == null) {
                listeners = new CopyOnWriteArrayList<SearchResultListener<ID>>();
                this.localListenMatcher.put(matcher, listeners);
            }
            if (add) {
                listeners.add(listener);
            } else {
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    this.localListenMatcher.remove(matcher);
                }
            }
        }
        GUID listenerID = this.manager.getListenerID(listener);
        this.persistence.sendEvent((Object)new RegisterSearchListenerMatcherEvent(this.indexTagID, listenerID, matcher.getToken(), matcher.getOperator(), add));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCloudMatcherChangedListener(@Nonnull RegisterSearchListenerMatcherEvent event) {
        Comparable token = TagIndex.convertToken((Object)event.token, (SearchTag)this.searchTag);
        ListenerTokenMatcher matcher = new ListenerTokenMatcher((Object)token, event.operator);
        SearchListenerContainer searchListenerContainer = this;
        synchronized (searchListenerContainer) {
            List<GUID> listeners;
            if (this.cloudListenMatcher == null) {
                this.cloudListenMatcher = new ConcurrentHashMap();
            }
            if ((listeners = this.cloudListenMatcher.get(matcher)) == null) {
                listeners = new CopyOnWriteArrayList<GUID>();
                this.cloudListenMatcher.put(matcher, listeners);
            }
            if (event.add) {
                listeners.add(event.listenerID);
            } else {
                listeners.remove(event.listenerID);
                if (listeners.size() == 0) {
                    this.cloudListenMatcher.remove(matcher);
                }
            }
        }
    }
}

