/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import java.awt.Graphics2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.script.ScriptSupport;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLUnderOverElement;

public abstract class AbstractUnderOver
extends AbstractJEuclidElement
implements MathMLUnderOverElement {
    public static final String UNDER_OVER_SPACE = "0.1ex";
    public static final float NON_ACCENT_MULTIPLIER = 2.5f;
    public static final String ATTR_ACCENT = "accent";
    public static final String ATTR_ACCENTUNDER = "accentunder";

    public AbstractUnderOver(MathBase base) {
        super(base);
    }

    public String getAccent() {
        return this.getMathAttribute(ATTR_ACCENT);
    }

    protected boolean getAccentAsBoolean() {
        return Boolean.parseBoolean(this.getAccent());
    }

    protected boolean limitsAreMoved() {
        return !this.getAccentAsBoolean() && this.getBase() instanceof Mo && Boolean.parseBoolean(((Mo)this.getBase()).getMovablelimits()) && !this.getParent().isChildBlock(this);
    }

    protected float getUnderBaselineShift(Graphics2D g) {
        float shift;
        JEuclidElement base = this.getBase();
        JEuclidElement underScript = this.getUnderscript();
        float baseshift = base.getDescentHeight(g);
        if (this.limitsAreMoved()) {
            shift = ScriptSupport.getSubBaselineShift(g, base, underScript, this.getOverscript());
        } else {
            float extraShift = AttributesHelper.convertSizeToPt(UNDER_OVER_SPACE, this, "pt");
            if (!this.getAccentunderAsBoolean()) {
                extraShift *= 2.5f;
            }
            shift = baseshift + extraShift + underScript.getAscentHeight(g);
        }
        return shift;
    }

    protected float getOverBaselineShift(Graphics2D g) {
        float shift;
        JEuclidElement base = this.getBase();
        JEuclidElement overScript = this.getOverscript();
        float baseAHeight = base.getAscentHeight(g);
        if (this.limitsAreMoved()) {
            shift = ScriptSupport.getSuperBaselineShift(g, base, this.getUnderscript(), overScript);
        } else {
            float extraShift = AttributesHelper.convertSizeToPt(UNDER_OVER_SPACE, this, "pt");
            if (!this.getAccentAsBoolean()) {
                extraShift *= 2.5f;
            }
            shift = baseAHeight + overScript.getDescentHeight(g) + extraShift;
        }
        return shift;
    }

    public final float calculateAscentHeight(Graphics2D g) {
        JEuclidElement over = this.getOverscript();
        float baseAscent = this.getBase().getAscentHeight(g);
        float overAscent = over != null ? this.getOverBaselineShift(g) + over.getAscentHeight(g) : 0.0f;
        return Math.max(baseAscent, overAscent);
    }

    public final float calculateDescentHeight(Graphics2D g) {
        JEuclidElement under = this.getUnderscript();
        float baseDescent = this.getBase().getDescentHeight(g);
        float underDescent = under != null ? this.getUnderBaselineShift(g) + under.getDescentHeight(g) : 0.0f;
        return Math.max(baseDescent, underDescent);
    }

    public float getXCenter(Graphics2D g) {
        float baseCenter = this.getBase().getXCenter(g);
        if (this.limitsAreMoved()) {
            return baseCenter;
        }
        JEuclidElement underElement = this.getUnderscript();
        float underCenter = underElement != null ? underElement.getXCenter(g) : 0.0f;
        JEuclidElement overElement = this.getOverscript();
        float overCenter = overElement != null ? overElement.getXCenter(g) : 0.0f;
        return Math.max(baseCenter, Math.max(overCenter, underCenter));
    }

    public float calculateWidth(Graphics2D g) {
        float baseWidth = this.getBase().getWidth(g);
        JEuclidElement underElement = this.getUnderscript();
        float underWidth = underElement != null ? underElement.getWidth(g) : 0.0f;
        JEuclidElement overElement = this.getOverscript();
        float overWidth = overElement != null ? overElement.getWidth(g) : 0.0f;
        Offsets o = this.calculateOffsets(g);
        return Math.max(baseWidth + o.getBase(), Math.max(overWidth + o.getOver(), underWidth + o.getUnder()));
    }

    private Offsets calculateOffsets(Graphics2D g) {
        float overOffsetX;
        float underOffsetX;
        float baseOffsetX;
        JEuclidElement base = this.getBase();
        JEuclidElement under = this.getUnderscript();
        JEuclidElement over = this.getOverscript();
        if (this.limitsAreMoved()) {
            float baseWidth;
            baseOffsetX = 0.0f;
            underOffsetX = baseWidth = base.getWidth(g);
            overOffsetX = baseWidth;
        } else {
            float baseCenter = base.getXCenter(g);
            float underCenter = under != null ? under.getXCenter(g) : 0.0f;
            float overCenter = over != null ? over.getXCenter(g) : 0.0f;
            float totalXCenter = Math.max(baseCenter, Math.max(underCenter, overCenter));
            underOffsetX = totalXCenter - underCenter;
            overOffsetX = totalXCenter - overCenter;
            baseOffsetX = totalXCenter - baseCenter;
        }
        return new Offsets(baseOffsetX, underOffsetX, overOffsetX);
    }

    public final void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        Offsets o = this.calculateOffsets(g);
        float baseOffsetX = o.getBase();
        float underOffsetX = o.getUnder();
        float overOffsetX = o.getOver();
        JEuclidElement base = this.getBase();
        JEuclidElement under = this.getUnderscript();
        JEuclidElement over = this.getOverscript();
        base.paint(g, posX + baseOffsetX, posY);
        if (under != null) {
            under.paint(g, posX + underOffsetX, posY + this.getUnderBaselineShift(g));
        }
        if (over != null) {
            over.paint(g, posX + overOffsetX, posY - this.getOverBaselineShift(g));
        }
    }

    public String getAccentunder() {
        return this.getMathAttribute(ATTR_ACCENTUNDER);
    }

    public int getScriptlevelForChild(JEuclidElement child) {
        if (child.isSameNode(this.getBase())) {
            return this.getAbsoluteScriptLevel();
        }
        return this.getAbsoluteScriptLevel() + 1;
    }

    public boolean isChildBlock(JEuclidElement child) {
        if (child.isSameNode(this.getBase())) {
            return super.isChildBlock(child);
        }
        return false;
    }

    protected boolean getAccentunderAsBoolean() {
        return Boolean.parseBoolean(this.getAccentunder());
    }

    public JEuclidElement getBase() {
        return this.getMathElement(0);
    }

    public abstract JEuclidElement getOverscript();

    public abstract JEuclidElement getUnderscript();

    public void setAccent(String accent) {
        this.setAttribute(ATTR_ACCENT, accent);
    }

    public void setAccentunder(String accentunder) {
        this.setAttribute(ATTR_ACCENTUNDER, accentunder);
    }

    public void setBase(MathMLElement base) {
        this.setMathElement(0, base);
    }

    public boolean hasChildPostscripts(JEuclidElement child) {
        return this.limitsAreMoved() && child.isSameNode(this.getBase());
    }

    private static class Offsets {
        private final float base;
        private final float under;
        private final float over;

        public Offsets(float b, float u, float o) {
            this.base = b;
            this.under = u;
            this.over = o;
        }

        public float getBase() {
            return this.base;
        }

        public float getUnder() {
            return this.under;
        }

        public float getOver() {
            return this.over;
        }
    }
}

