/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import net.sourceforge.jeuclid.DOMBuilder;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathComponent
extends Component {
    private static final long serialVersionUID = 1L;
    private MathBase base;
    private boolean debug;
    private Document document;
    private Map<ParameterKey, String> parameters = MathBase.getDefaultParameters();

    public final void setParameters(Map<ParameterKey, String> newParameters) {
        this.parameters = newParameters;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.base == null) {
            return new Dimension(1, 1);
        }
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        return new Dimension((int)Math.ceil(this.base.getWidth(g2d)), (int)Math.ceil(this.base.getHeight(g2d)));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.base != null) {
            this.base.paint((Graphics2D)g);
        }
    }

    private void redo() {
        if (this.document != null) {
            this.base = new MathBase(this.parameters);
            new DOMBuilder(this.document, this.base);
            this.base.setDebug(this.debug);
        } else {
            this.base = null;
        }
        this.repaint();
    }

    public void setDebug(boolean debugMode) {
        this.debug = debugMode;
        this.redo();
    }

    public void setDocument(Document newDocument) {
        this.document = newDocument;
        this.redo();
    }
}

