/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.sun.jna.FunctionMapper;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class OdbcUtils {
    static final Map<String, Object> OPTIONS = new HashMap<String, Object>();

    OdbcUtils() {
    }

    static String getLibraryName() {
        OPTIONS.put("function-mapper", new UnicodeFunctionMapper());
        switch (Platform.getOSType()) {
            case 2: 
            case 6: {
                return "odbc32";
            }
            case 0: {
                return "iodbc";
            }
        }
        return "odbc";
    }

    static boolean isUnicode(NativeLibrary library) {
        if (OPTIONS.get("function-mapper") != null) {
            try {
                library.getFunction("SQLDriverConnectW");
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return false;
    }

    static short getJdbcType(short odbcType) {
        switch (odbcType) {
            case 9: {
                return 93;
            }
            case -8: {
                return -15;
            }
            case -9: {
                return -9;
            }
            case -10: {
                return -16;
            }
        }
        return odbcType;
    }

    static short getOdbcType(int jdbcType) {
        switch (jdbcType) {
            case -15: {
                return -8;
            }
            case -9: {
                return -9;
            }
            case -16: {
                return -10;
            }
        }
        return (short)jdbcType;
    }

    private static class UnicodeFunctionMapper
    implements FunctionMapper {
        private UnicodeFunctionMapper() {
        }

        public String getFunctionName(NativeLibrary library, Method method) {
            String name = method.getName();
            if (!name.endsWith("W") && !name.endsWith("A")) {
                try {
                    name = library.getFunction(name + "W").getName();
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            return name;
        }
    }
}

