/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.OdbcConnection;
import com.inet.odbc.OdbcLibrary;
import com.inet.odbc.OdbcResultSet;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ShortByReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

class OdbcStatement
implements Statement {
    private final OdbcConnection con;
    private Pointer hStmt;
    private SQLWarning warnings;

    OdbcStatement(OdbcConnection con, Pointer hStmt) {
        this.con = con;
        this.hStmt = hStmt;
    }

    void checkSqlReturn(short ret) throws SQLException {
        this.warnings = null;
        this.warnings = this.con.checkSqlReturn(ret, this.hStmt);
    }

    Pointer getHStmt() {
        return this.hStmt;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(this.executeImpl(sql));
    }

    ResultSet executeQuery(int columnCount) throws SQLException {
        if (columnCount > 0) {
            return new OdbcResultSet(this, columnCount);
        }
        throw new SQLException("No ResultSet was produced");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return 0;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeImpl(sql) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeImpl(String sql) throws SQLException {
        byte[] data = this.con.toBytes(sql);
        Object object = this.con.getLock();
        synchronized (object) {
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLFreeStmt(this.hStmt, (short)0));
            this.checkSqlReturn(OdbcLibrary.ODBC.SQLExecDirect(this.hStmt, data, data.length / OdbcLibrary.FACTOR));
            return this.getColumnCount();
        }
    }

    int getColumnCount() throws SQLException {
        ShortByReference columnCount = new ShortByReference();
        this.checkSqlReturn(OdbcLibrary.ODBC.SQLNumResultCols(this.hStmt, columnCount));
        return columnCount.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            Object object = this.con.getLock();
            synchronized (object) {
                if (!this.isClosed() && !this.con.isClosed()) {
                    this.checkSqlReturn(OdbcLibrary.ODBC.SQLFreeStmt(this.hStmt, (short)1));
                    this.hStmt = Pointer.NULL;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public OdbcConnection getConnection() {
        return this.con;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.hStmt == Pointer.NULL;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(this.getClass().getName() + " does not implements " + iface.getName() + ".", "01000");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

