/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.AbstractOdbcResultSet;
import com.inet.odbc.ColumnDescription;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class OdbcInputStream
extends InputStream {
    private ColumnDescription column;
    private AbstractOdbcResultSet rs;
    private final byte[] readBuffer = new byte[4096];
    private final byte[] buffer;
    private final int convertType;
    private int offset;
    private int length;
    static final int BINARY = 1;
    static final int ASCII = 2;
    private static final int ASCII2UNICODE = 3;
    static final int UNICODE = 4;
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    OdbcInputStream(AbstractOdbcResultSet rs, ColumnDescription column, int streamType) throws SQLException {
        int factor;
        this.rs = rs;
        this.column = column;
        short odbcType = column.getOdbcType();
        switch (odbcType) {
            case -4: 
            case -3: 
            case -2: {
                this.convertType = factor = streamType;
                break;
            }
            default: {
                if (streamType == 4) {
                    this.convertType = 3;
                    factor = 2;
                    break;
                }
                factor = 1;
                this.convertType = 1;
            }
        }
        this.buffer = this.convertType == 1 ? this.readBuffer : new byte[this.readBuffer.length * factor];
    }

    @Override
    public int read() throws IOException {
        if (!this.checkBuffer()) {
            return -1;
        }
        return this.buffer[this.offset++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.checkBuffer()) {
            return -1;
        }
        len = Math.min(len, this.length - this.offset);
        System.arraycopy(this.buffer, this.offset, b, off, len);
        this.offset += len;
        return len;
    }

    @Override
    public int available() throws IOException {
        if (!this.checkBuffer()) {
            return 0;
        }
        return Math.max(0, this.length - this.offset);
    }

    private boolean checkBuffer() throws IOException {
        if (this.offset >= this.length) {
            try {
                this.length = this.rs.getData(this.column, this.readBuffer);
                this.convert();
                this.offset = 0;
            }
            catch (SQLException ex) {
                throw new IOException(ex);
            }
            if (this.offset >= this.length) {
                return false;
            }
        }
        return true;
    }

    private void convert() {
        switch (this.convertType) {
            case 1: {
                return;
            }
            case 2: {
                for (int i = 0; i < this.length; ++i) {
                    byte b = this.readBuffer[i];
                    this.buffer[i * 2] = DIGITS[b >> 4 & 0xF];
                    this.buffer[i * 2 + 1] = DIGITS[b & 0xF];
                }
                this.length *= 2;
                break;
            }
            case 3: {
                int j = 0;
                for (int i = 0; i < this.length; ++i) {
                    this.buffer[j++] = 0;
                    this.buffer[j++] = this.readBuffer[i];
                }
                this.length *= 2;
                break;
            }
            case 4: {
                int j = 0;
                for (int i = 0; i < this.length; ++i) {
                    byte b = this.readBuffer[i];
                    this.buffer[j++] = 0;
                    this.buffer[j++] = DIGITS[b >> 4 & 0xF];
                    this.buffer[j++] = 0;
                    this.buffer[j++] = DIGITS[b & 0xF];
                }
                this.length *= 4;
            }
        }
    }
}

