/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.OdbcConnection;
import com.inet.odbc.OdbcLibrary;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class OdbcDriver
implements Driver {
    static final int MAJOR_VERSION = 1;
    static final int MINOR_VERSION = 7;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        info = (Properties)info.clone();
        info.put("jdbcurl", url);
        return new OdbcConnection(info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:odbc:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 7;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            if (OdbcLibrary.ODBC != null) {
                DriverManager.registerDriver(new OdbcDriver());
            }
        }
        catch (SQLException ex) {
            DriverManager.getLogWriter().print("Unable to register driver");
        }
        catch (Error th) {
            if (DriverManager.getLogWriter() != null) {
                th.printStackTrace(DriverManager.getLogWriter());
            }
            throw th;
        }
    }
}

