/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.ui.TargetChild;
import com.inet.usersandgroups.api.ui.TargetEntry;
import com.inet.usersandgroups.api.ui.TargetParent;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class TargetValue {
    private List<TargetEntry> targets;
    private List<String> groupTypeKeys;

    private TargetValue() {
    }

    public TargetValue(List<TargetEntry> targets) {
        this.targets = targets;
        this.groupTypeKeys = TargetValue.getAllGroupTypeKeys();
    }

    private static List<String> getAllGroupTypeKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        List<@Nonnull GroupTypeDef> list = serverPluginManager.get(GroupTypeDef.class);
        for (GroupTypeDef groupTypeDef : list) {
            arrayList.add(groupTypeDef.getGroupType().getName());
        }
        return arrayList;
    }

    public List<TargetEntry> getTargets() {
        return this.targets;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public static TargetValue getValue(Map<Type, Set<@Nonnull GUID>> value) {
        Object object;
        Object object2;
        ArrayList<TargetEntry> arrayList = new ArrayList<TargetEntry>();
        Set<@Nonnull GUID> set = value.get((Object)Type.user);
        Set<@Nonnull GUID> set2 = value.get((Object)Type.group);
        if (set != null) {
            object2 = UserManager.getInstance();
            for (GUID object3 : set) {
                UserAccount userAccount = ((UserManager)object2).getUserAccount(object3);
                if (userAccount == null) continue;
                object = new TargetEntry(object3, Type.user, userAccount.getAccountType().name(), userAccount.getDisplayName());
                arrayList.add((TargetEntry)object);
            }
        }
        if (set2 != null) {
            object2 = UserGroupManager.getInstance();
            Set<UserGroupInfo> set3 = ((UserGroupManager)object2).getAllGroups();
            for (GUID gUID : set2) {
                void var13_16;
                object = ((UserGroupManager)object2).getGroup(gUID);
                if (object == null || !((UserGroupInfo)object).isActive()) continue;
                TargetEntry targetEntry = new TargetEntry(gUID, Type.group, ((UserGroupInfo)object).getType().getName(), ((UserGroupInfo)object).getDisplayName());
                UserGroupTreeUtils.DescendantGroups descendantGroups = UserGroupTreeUtils.findDescendantGroups((UserGroupInfo)object, set3);
                ArrayList<TargetChild> arrayList2 = new ArrayList<TargetChild>();
                for (UserGroupInfo userGroupInfo : descendantGroups.getDescendantGroups()) {
                    arrayList2.add(new TargetChild(userGroupInfo.getID(), userGroupInfo.getDisplayName()));
                }
                targetEntry.setChildren(arrayList2);
                ArrayList arrayList3 = new ArrayList();
                Object object3 = object;
                while (var13_16.hasParent()) {
                    UserGroupInfo userGroupInfo = ((UserGroupManager)object2).getGroup(var13_16.getParentID());
                    arrayList3.add(new TargetParent(userGroupInfo.getID(), userGroupInfo.getDisplayName()));
                }
                targetEntry.setParents(arrayList3);
                arrayList.add(targetEntry);
            }
        }
        return new TargetValue(arrayList);
    }

    public static Map<Type, Set<GUID>> getReceivers(String value) {
        TargetValue targetValue = new Json().fromJson(value, TargetValue.class);
        return TargetValue.getReceivers(targetValue);
    }

    public static Map<Type, Set<GUID>> getReceivers(TargetValue targetValue) {
        HashMap<Type, Set<GUID>> hashMap = new HashMap<Type, Set<GUID>>();
        HashSet<GUID> hashSet = new HashSet<GUID>();
        HashSet<GUID> hashSet2 = new HashSet<GUID>();
        for (TargetEntry targetEntry : targetValue.getTargets()) {
            if (targetEntry.isDummy()) continue;
            if (Type.user == targetEntry.getEntryType()) {
                hashSet2.add(targetEntry.getGuid());
            }
            if (Type.group != targetEntry.getEntryType()) continue;
            hashSet.add(targetEntry.getGuid());
        }
        hashMap.put(Type.group, hashSet);
        hashMap.put(Type.user, hashSet2);
        return hashMap;
    }
}

