/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions.url;

import com.inet.annotations.InternalApi;
import com.inet.logging.LogManager;
import com.inet.permissions.url.PermissionJsonUtils;
import com.inet.permissions.url.PermissionUrlObject;
import com.inet.permissions.url.legacy.OldPermissionUrlObject;
import com.inet.permissions.url.legacy.OldPermissionXMLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class FilePermissions {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_EXECUTE = 1;
    public static final int TYPE_WRITE = 2;
    public static final int TYPE_READ = 4;
    public static final int TYPE_ALL = 7;

    public static void setPermission(URL url, PermissionUrlObject permission) throws IOException {
        PermissionJsonUtils.writePermission(permission, url);
    }

    @Nullable
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check that only save URLs are used")
    public static PermissionUrlObject getPermission(URL url) {
        InputStream inputStream = null;
        PermissionUrlObject permissionUrlObject = null;
        try {
            inputStream = new URL(url, ".inet.permissions").openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            permissionUrlObject = FilePermissions.getPermission(inputStream);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return permissionUrlObject;
        }
        OldPermissionUrlObject oldPermissionUrlObject = null;
        InputStream inputStream2 = null;
        try {
            inputStream2 = new URL(url, "reportPermissions.xml").openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream2 != null) {
            oldPermissionUrlObject = FilePermissions.a(inputStream2);
            try {
                inputStream2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            PermissionUrlObject permissionUrlObject2 = FilePermissions.a(oldPermissionUrlObject, url);
            return permissionUrlObject2;
        }
        return null;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private static PermissionUrlObject a(OldPermissionUrlObject oldPermissionUrlObject, URL uRL) {
        PermissionUrlObject permissionUrlObject;
        block8: {
            permissionUrlObject = PermissionJsonUtils.convertOldPermission(oldPermissionUrlObject);
            boolean bl = true;
            try {
                PermissionJsonUtils.writePermission(permissionUrlObject, new URL(uRL, ".inet.permissions"), false);
            }
            catch (IOException iOException) {
                if (LogManager.getApplicationLogger().isError()) {
                    LogManager.getApplicationLogger().error(iOException);
                }
                bl = false;
            }
            if (bl) {
                try {
                    new File(new URL(uRL, "reportPermissions.xml").toURI()).delete();
                }
                catch (MalformedURLException malformedURLException) {
                    if (LogManager.getApplicationLogger().isDebug()) {
                        LogManager.getApplicationLogger().debug(malformedURLException.getMessage());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    if (!LogManager.getApplicationLogger().isDebug()) break block8;
                    LogManager.getApplicationLogger().debug(uRISyntaxException.getMessage());
                }
            }
        }
        return permissionUrlObject;
    }

    @Nullable
    public static PermissionUrlObject getPermission(InputStream stream) {
        if (stream == null) {
            return null;
        }
        PermissionUrlObject permissionUrlObject = PermissionJsonUtils.read(stream);
        return permissionUrlObject;
    }

    private static OldPermissionUrlObject a(InputStream inputStream) {
        return OldPermissionXMLUtils.readPermission(inputStream);
    }

    public static String getStringRepresentation(int level) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((level & 2) == 2) {
            stringBuilder.append(" Write ");
        }
        if ((level & 4) == 4) {
            stringBuilder.append(" Read ");
        }
        if ((level & 1) == 1) {
            stringBuilder.append(" Execute ");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(" None ");
        }
        return stringBuilder.toString();
    }
}

