/*
 * Decompiled with CFR 0.152.
 */
package com.inet.id;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.lib.util.StringFunctions;
import com.inet.shared.utils.WeakValueMap;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class GUID
implements Serializable,
Comparable<GUID> {
    public static final int MINIMUM_LENGTH = 25;
    private static final WeakValueMap<String, GUID> VALUE_POOL = new WeakValueMap();
    @Nonnull
    private String id;

    public GUID(@Nonnull String id) throws IllegalArgumentException {
        GUID.checkID((String)id);
        if (((String)id).length() < 25) {
            id = (String)id + new String(new char[25 - ((String)id).length()]).replace('\u0000', '0');
        }
        this.id = id;
    }

    public static void checkID(String id) throws IllegalArgumentException {
        if (StringFunctions.isEmpty(id)) {
            throw new IllegalArgumentException("GUID can not be empty");
        }
        for (char c2 : id.toCharArray()) {
            if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z') continue;
            throw new IllegalArgumentException("Invalid GUID: '" + id + "'");
        }
    }

    public static List<Character> getAllValidCharacters() {
        char c2;
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (c2 = '0'; c2 <= '9'; c2 = (char)(c2 + '\u0001')) {
            arrayList.add(Character.valueOf(c2));
        }
        for (c2 = 'a'; c2 <= 'z'; c2 = (char)(c2 + '\u0001')) {
            arrayList.add(Character.valueOf(c2));
        }
        return arrayList;
    }

    @Nonnull
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((GUID)obj).id);
    }

    @Nullable
    public static GUID valueOf(String value) throws IllegalArgumentException {
        if (StringFunctions.isEmpty(value)) {
            return null;
        }
        GUID gUID = VALUE_POOL.get(value);
        if (gUID != null) {
            return gUID;
        }
        gUID = new GUID(value);
        VALUE_POOL.put(value, gUID);
        return gUID;
    }

    public static int getPoolCount() {
        return VALUE_POOL.size();
    }

    @Nonnull
    public static GUID generateNew() {
        UUID uUID = UUID.randomUUID();
        return GUID.generateBasedOn(uUID);
    }

    @Nonnull
    public static GUID generateFor(int value) {
        UUID uUID = UUID.nameUUIDFromBytes(String.valueOf(value).getBytes(StandardCharsets.UTF_8));
        return GUID.generateBasedOn(uUID);
    }

    @Nonnull
    private static GUID generateBasedOn(UUID uuid) {
        Object object = new BigInteger(uuid.toString().replace("-", ""), 16).toString(36);
        if (((String)object).length() < 25) {
            object = new String(new char[25 - ((String)object).length()]).replace('\u0000', '0') + (String)object;
        }
        return new GUID((String)object);
    }

    @Deprecated
    public String toSQLString() {
        return "'" + this.toString() + "'";
    }

    @Override
    public int compareTo(@Nonnull GUID o2) {
        return this.id.compareTo(o2.id);
    }
}

