/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.currenttime;

import java.io.IOException;
import java.util.HashMap;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import com.inet.remote.gui.angular.AngularContentService;
import com.inet.remote.gui.angular.AngularApplicationServlet;
import com.inet.remote.gui.angular.ModuleMetaData;

/**
 * The handler is responsible to serve the content of our application according to the requested relative path.
 */
public class SampleApplicationHandler extends AngularApplicationServlet {

    /**
     * Creates the handler for the sample application path
     */
    public SampleApplicationHandler() {
        super( SampleApplicationModule.PATH );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void handleGet( HttpServletRequest request, HttpServletResponse response, String pathInfo, HashMap<String, String> replace ) throws IOException {
        // If the relative path (below .../sampleapp/) is empty or not set, the template with our HTML must be served to the client 
        if( pathInfo == null || pathInfo.trim().isEmpty() || pathInfo.trim().equals( "/" ) ) {
            // Describes the module/application
            ModuleMetaData moduleMetaData = new ModuleMetaData( getPath(), getClass().getResource( "sampleapplication.html" ) );
            // Optionial javascript pathes can be added. The references must be registered in the server plugin
            moduleMetaData.addJsPath( SampleApplicationServerPlugin.APPLICATION_SPECIFIC_JS );
            // Now serve the template to the client
            AngularContentService.serveTemplate( request, response, null, moduleMetaData );
            return;
        }
        // If another relative path is requested, a resource with that name should be served.
        // For security reasons you can implement a handling for each file that is allowed to be served.
        AngularContentService.serveStaticContent( request, response, getClass().getResource( pathInfo ), getPath(), true );

    }

}
