/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.authentication.oauth.ex;

import com.inet.authentication.oauth2.api.OAuthServerDescription;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;

/**
 * Server plugin to register the extension
 */
@PluginInfo( //
id = "authentication.oauth.ex", //
version = "25.10.198", //
dependencies = "authentication.oauth", //
group = "samples", //
icon = "com/inet/authentication/oauth/ex/login_oauth_48.png" //
)public class OAuthExServerPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        // register the OAuth service
        spm.register( OAuthServerDescription.class, new OAuthExServerDescription() );

        // register a UI extension for setting, this is only needed if the settings are not hard coded
        spm.register( ConfigStructureProvider.class, new OAuthExStructureProvider() );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
