/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.helloworld;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import javax.annotation.Nonnull;

import com.inet.http.PluginServlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

/**
 * The handler is responsible to serve the content of our application according to the requested relative path.
 */
public class HelloWorldPluginServlet implements PluginServlet {

    /**
     * {@inheritDoc}
     */
    @Override
    public @Nonnull String getPathSpec() {
        return "/hello";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServletConfig config ) throws ServletException {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void destroy() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void service( HttpServletRequest request, HttpServletResponse response ) throws ServletException, IOException {
        String content = "<http><body><h1>Hello World</h1></body></http>";
        response.setContentType( "text/html; charset=utf-8" );
        response.getOutputStream().write( content.getBytes( StandardCharsets.UTF_8 ) );
    }
}
