/*
 * Decompiled with CFR 0.152.
 */
package com.inet.excel;

import com.inet.excel.ExcelDriver;
import com.inet.excel.ExcelResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class ExcelDatabaseResultSet
extends ExcelResultSet {
    private List<List<Object>> rows;
    private int currentRowIndex;
    private boolean wasNull;

    public ExcelDatabaseResultSet(List<String> columnNames, List<List<Object>> rows) {
        super(columnNames);
        if (rows == null) {
            throw new IllegalArgumentException("list of rows must not be null");
        }
        if (rows.stream().anyMatch(row -> row.size() != columnNames.size())) {
            throw new IllegalArgumentException("number of values in all rows must match number of columns");
        }
        this.rows = rows;
        this.currentRowIndex = -1;
        this.wasNull = false;
    }

    @Override
    public boolean next() throws SQLException {
        this.throwIfAlreadyClosed();
        ++this.currentRowIndex;
        if (this.currentRowIndex >= this.rows.size()) {
            this.currentRowIndex = this.rows.size();
            return false;
        }
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.rows = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ExcelDriver.throwExceptionAboutUnsupportedOperation();
        return null;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.throwIfAlreadyClosed();
        return this.currentRowIndex >= this.rows.size();
    }

    @Override
    public int getRow() throws SQLException {
        this.throwIfAlreadyClosed();
        if (this.currentRowIndex >= this.rows.size()) {
            return 0;
        }
        return this.currentRowIndex + 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rows == null;
    }

    @Override
    protected <T> T getValue(int columnIndex) throws SQLException {
        this.throwIfAlreadyClosedOrReachedEnd();
        this.throwIfColumnIndexIsInvalid(columnIndex);
        Object value = this.rows.get(this.currentRowIndex).get(columnIndex - 1);
        this.wasNull = value == null;
        return (T)value;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.throwIfAlreadyClosed();
        return this.wasNull;
    }
}

