/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.presentation.token.AbstractTokenWithTextLayout;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.font.FontFactory;
import org.w3c.dom.mathml.MathMLGlyphElement;

public class Mglyph
extends AbstractTokenWithTextLayout
implements MathMLGlyphElement {
    public static final String ELEMENT = "mglyph";
    private static final String ATTR_ALT = "alt";
    private static final String ATTR_FONTFAMILY = "fontfamily";
    private static final String ATTR_INDEX = "index";

    public Mglyph(MathBase base) {
        super(base);
    }

    protected AttributedString textContentAsAttributedString() {
        AttributedString retVal;
        String fontFamily = this.getFontfamily().trim();
        Font font = FontFactory.getInstance().getFont(fontFamily, 0, (int)this.getFontsizeInPoint());
        int codePoint = this.getIndex();
        if (font.getFamily().equalsIgnoreCase(fontFamily) && font.canDisplay(codePoint)) {
            retVal = new AttributedString(new String(new int[]{codePoint}, 0, 1));
            retVal.addAttribute(TextAttribute.FONT, font);
        } else {
            retVal = StringUtil.convertStringtoAttributedString(this.getAlt(), this.getMathvariantAsVariant(), this.getFontsizeInPoint(), this.getMathBase());
        }
        return retVal;
    }

    protected boolean isEmpty() {
        return false;
    }

    public String getAlt() {
        return this.getMathAttribute(ATTR_ALT);
    }

    public String getFontfamily() {
        return this.getMathAttribute(ATTR_FONTFAMILY);
    }

    public int getIndex() {
        return Integer.parseInt(this.getMathAttribute(ATTR_INDEX));
    }

    public void setAlt(String alt) {
        this.setAttribute(ATTR_ALT, alt);
    }

    public void setFontfamily(String fontfamily) {
        this.setAttribute(ATTR_FONTFAMILY, fontfamily);
    }

    public void setIndex(int index) {
        this.setAttribute(ATTR_INDEX, Integer.toString(index));
    }

    public String getTagName() {
        return ELEMENT;
    }
}

