/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.MathMLParserSupport;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Converter {
    private static Converter converter;
    private static final Log LOGGER;

    private Converter() {
    }

    public static Converter getConverter() {
        if (converter == null) {
            converter = new Converter();
        }
        return converter;
    }

    public Dimension convert(File inFile, File outFile, String outFileType) throws IOException {
        Map<ParameterKey, String> params = MathBase.getDefaultParameters();
        params.put(ParameterKey.OutFileType, outFileType);
        return this.convert(inFile, outFile, params);
    }

    public Dimension convert(File inFile, File outFile, Map<ParameterKey, String> params) throws IOException {
        try {
            Document doc = MathMLParserSupport.parseFile(inFile);
            return this.convert((Node)doc, outFile, params);
        }
        catch (SAXException e) {
            LOGGER.error((Object)("Failed to parse file:" + inFile), (Throwable)e);
            return null;
        }
    }

    public Dimension convert(Node doc, File outFile, Map<ParameterKey, String> params) throws IOException {
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outFile));
        Dimension result = this.convert(doc, outStream, params);
        if (result != null) {
            try {
                ((OutputStream)outStream).close();
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
        } else {
            outFile.delete();
        }
        return result;
    }

    public Dimension convert(Node doc, OutputStream outStream, Map<ParameterKey, String> params) throws IOException {
        ConverterPlugin plugin = ConverterRegistry.getRegisty().getConverter(params.get((Object)ParameterKey.OutFileType));
        Dimension result = null;
        if (plugin != null) {
            try {
                result = plugin.convert(MathMLParserSupport.createMathBaseFromDocument(doc, params), outStream);
            }
            catch (SAXException ex) {
                LOGGER.fatal((Object)("Failed to process: " + ex.getMessage()), (Throwable)ex);
            }
        } else {
            LOGGER.fatal((Object)("Unsupported output type: " + params.get((Object)ParameterKey.OutFileType)));
        }
        return result;
    }

    public BufferedImage render(MathBase base) throws IOException {
        BufferedImage tempimage = new BufferedImage(1, 1, 2);
        Graphics2D tempg = (Graphics2D)((Image)tempimage).getGraphics();
        int width = (int)Math.ceil(base.getWidth(tempg));
        int height = (int)Math.ceil(base.getHeight(tempg));
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        Color transparency = new Color(255, 255, 255, 0);
        g.setColor(transparency);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        base.paint(g);
        return image;
    }

    static {
        LOGGER = LogFactory.getLog(Converter.class);
    }
}

