/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication;

import com.inet.annotations.PublicApi;
import com.inet.authentication.AuthenticationProvider;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class AuthenticationDescription {
    public static final String PROVIDER = "provider";
    public static final String DISPLAYNAME = "displayname";
    public static final String DISPLAYNAME_DETAILS = "details";
    public static final String COLOR = "color";
    public static final String PROVIDER_SYSTEM = "system";
    public static final String PROVIDER_PRODUCT = "product";
    public static final String SYSTEM_PROVIDER_ACTION = "system.action";
    public static final String SYSTEM_LOGINTYPE = "logintype";
    public static final String USER_CAN_REGISTER = "userCanRegister";
    public static final String PASSWORD_MINIMUM_LENGTH = "minimumPasswordLength";
    public static final String PASSWORD_MINIMUM_STRENGTH = "minimumPasswordStrength";
    public static final String[] PASSWORD_MINIMUM_STRENGTH_VALUES = new String[]{"weak", "medium", "strong"};
    @Nonnull
    private AuthenticationProvider a;
    @Nonnull
    private Map<String, String> b;
    @Nonnull
    private String c;
    @Nonnull
    private BasicSupport d;

    public AuthenticationDescription(@Nonnull AuthenticationProvider provider, @Nonnull Map<String, String> settings, @Nonnull String name, @Nonnull BasicSupport basicSupport) {
        this.a = Objects.requireNonNull(provider);
        this.b = Objects.requireNonNull(settings);
        this.c = Objects.requireNonNull(name);
        this.d = Objects.requireNonNull(basicSupport);
    }

    @Nonnull
    public AuthenticationProvider getProvider() {
        return this.a;
    }

    @Nonnull
    public Map<String, String> getSettings() {
        return this.b;
    }

    @Nonnull
    public String getName() {
        return this.c;
    }

    public String getDisplayName() {
        return this.a.getDisplayName(this.b);
    }

    public String getColor() {
        return this.b.get(COLOR);
    }

    public URL getIconURL() {
        String string = this.b.get("icon");
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nonnull
    public BasicSupport getBasicSupport() {
        return this.d;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.d, this.c, this.a, this.b});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationDescription authenticationDescription = (AuthenticationDescription)obj;
        return this.d == authenticationDescription.d && Objects.equals(this.c, authenticationDescription.c) && Objects.equals(this.a.name(), authenticationDescription.a.name()) && Objects.equals(this.b, authenticationDescription.b);
    }

    public static final class BasicSupport
    extends Enum<BasicSupport> {
        public static final /* enum */ BasicSupport No = new BasicSupport();
        public static final /* enum */ BasicSupport Only = new BasicSupport();
        public static final /* enum */ BasicSupport Also = new BasicSupport();
        private static final /* synthetic */ BasicSupport[] a;

        public static BasicSupport[] values() {
            return (BasicSupport[])a.clone();
        }

        public static BasicSupport valueOf(String name) {
            return Enum.valueOf(BasicSupport.class, name);
        }

        private static /* synthetic */ BasicSupport[] a() {
            return new BasicSupport[]{No, Only, Also};
        }

        static {
            a = BasicSupport.a();
        }
    }
}

