/*
 * Decompiled with CFR 0.152.
 */
package jbarcodebean;

import jbarcodebean.BarcodeElement;
import jbarcodebean.BarcodeException;
import jbarcodebean.BarcodeStrategy;
import jbarcodebean.EncodedBarcode;

public abstract class AbstractBarcodeStrategy
implements BarcodeStrategy {
    protected abstract CharacterCode[] getCodes();

    protected abstract String augmentWithChecksum(String var1) throws BarcodeException;

    protected abstract String preprocess(String var1) throws BarcodeException;

    protected abstract boolean isInterleaved();

    protected abstract char getStartSentinel();

    protected abstract char getStopSentinel();

    protected abstract byte getMarginWidth();

    protected abstract String getBarcodeLabelText(String var1);

    protected abstract String postprocess(String var1);

    public EncodedBarcode encode(String string, boolean bl) throws BarcodeException {
        String string2 = this.preprocess(string);
        string2 = bl ? this.augmentWithChecksum(string2) : string2;
        string2 = this.postprocess(string2);
        if (this.getStartSentinel() != '\uffff' && string2.indexOf(this.getStartSentinel()) >= 0 || string2.indexOf(this.getStopSentinel()) >= 0) {
            throw new BarcodeException("Invalid character in barcode");
        }
        if (this.getStartSentinel() != '\uffff') {
            string2 = this.getStartSentinel() + string2;
        }
        string2 = string2 + this.getStopSentinel();
        int n = this.computeSize(string2);
        BarcodeElement[] barcodeElementArray = new BarcodeElement[n];
        barcodeElementArray[0] = new BarcodeElement();
        barcodeElementArray[0].bar = false;
        barcodeElementArray[0].width = this.getMarginWidth();
        int n2 = string2.length();
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            CharacterCode characterCode = this.getCharacterCode(c);
            if (characterCode == null) {
                throw new BarcodeException("Invalid character in barcode");
            }
            for (int j = 0; j < characterCode.widths.length; ++j) {
                barcodeElementArray[n3] = new BarcodeElement();
                barcodeElementArray[n3].width = characterCode.widths[j];
                boolean bl2 = barcodeElementArray[n3].bar = n3 % 2 != 0;
                if (this.isInterleaved() && c != this.getStartSentinel() && c != this.getStopSentinel()) {
                    n3 += 2;
                    continue;
                }
                ++n3;
            }
            if (!this.isInterleaved() || c == this.getStartSentinel() || c == this.getStopSentinel()) continue;
            if (i % 2 == 1) {
                n3 -= characterCode.widths.length * 2 - 1;
                continue;
            }
            --n3;
        }
        barcodeElementArray[n3] = new BarcodeElement();
        barcodeElementArray[n3].bar = false;
        barcodeElementArray[n3].width = this.getMarginWidth();
        if (++n3 != n) {
            throw new BarcodeException("Unexpected barcode size");
        }
        return new EncodedBarcode(barcodeElementArray, this.getBarcodeLabelText(string));
    }

    protected int computeSize(String string) throws BarcodeException {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            CharacterCode characterCode = this.getCharacterCode(c);
            if (characterCode == null) {
                throw new BarcodeException("Invalid character in barcode");
            }
            n += characterCode.widths.length;
        }
        return n += 2;
    }

    protected CharacterCode getCharacterCode(char c) {
        CharacterCode[] characterCodeArray = this.getCodes();
        for (int i = 0; i < characterCodeArray.length; ++i) {
            if (characterCodeArray[i].character != c) continue;
            return characterCodeArray[i];
        }
        return null;
    }

    protected CharacterCode getCharacterCode(int n) {
        CharacterCode[] characterCodeArray = this.getCodes();
        for (int i = 0; i < characterCodeArray.length; ++i) {
            if (characterCodeArray[i].check != n) continue;
            return characterCodeArray[i];
        }
        return null;
    }

    public abstract /* synthetic */ int requiresChecksum();

    public static class CharacterCode {
        public char character;
        public byte[] widths;
        public int check;

        public CharacterCode(char c, byte[] byArray, int n) {
            this.character = c;
            this.widths = byArray;
            this.check = n;
        }
    }
}

