/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package com.inet.authentication.passwordfile;

/*
    either expressed or implied, including, but not limited to, the implied warranties
    of merchantability and/or fitness for a particular purpose. This programming example
    assumes that you are familiar with the programming language being demonstrated and
    the tools used to create and debug procedures. i-net software support professionals
    can help explain the functionality of a particular procedure, but they will not modify
    these examples to provide added functionality or construct procedures to meet your
    specific needs.
    © i-net software 1998-2017
*/
import java.io.IOException;

import javax.annotation.Nonnull;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.digest.DigestAccessAuthWUI;

/**
 * Implementation of RemoteWebUserInfo for Digest Access Authentication that works with password file.
 */
public class PasswordFileAuthWUI extends DigestAccessAuthWUI {

    private final PasswordFile passwordFile;
    
    /** Creates instance of {@link PasswordFileAuthWUI}.
     * @param description the AuthenticationDescription for creating this login processor
     * @param passwordFile responsible for reading data from password file.
     */
    public PasswordFileAuthWUI( AuthenticationDescription description, PasswordFile passwordFile ) {
        super( description );
        this.passwordFile = passwordFile;
    }

    /**
     * {@inheritDoc}
     */
    public @Nonnull String getLoginSource() {
        return PasswordFileAuthProvider.NAME;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean supportsRoles() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isWebUserInRole( String role ) {
        // the password file does not have any group information for the users
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getHashValueOfA1( String userName, String realm ) {
        try {
            return passwordFile.getHashValueOfA1( userName, realm );
        } catch( IOException ex ) {
            LOGGER.error( ex );
            return null;
        }
    }
}
