/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.servlet;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.EncodingFunctions;
import com.inet.shared.servlet.ServletUtils;
import com.inet.shared.servlet.a;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ProxyHttpServletRequest
extends HttpServletRequestWrapper {
    private String a;
    private HttpSession b;

    ProxyHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    @Nonnull
    public static ProxyHttpServletRequest wrapRequestIfNeeded(@Nonnull HttpServletRequest request) {
        if (request instanceof ProxyHttpServletRequest) {
            return (ProxyHttpServletRequest)request;
        }
        return new ProxyHttpServletRequest(request);
    }

    @Override
    public String getRequestURI() {
        if (this.a == null) {
            this.a = this.a();
        }
        return this.a;
    }

    @Nonnull
    private String a() {
        String string;
        Object object;
        try {
            object = this.getParameter("context");
            string = ProxyHttpServletRequest.getProxyContext(this);
        }
        catch (Throwable throwable) {
            string = null;
            object = null;
        }
        if (object != null && string != null) {
            if (((String)object).length() > 0 && !((String)object).startsWith("/")) {
                object = "/" + (String)object;
            }
            return string + EncodingFunctions.encodeUrlPath((String)object);
        }
        if (string != null) {
            String string2 = super.getContextPath();
            String string3 = super.getRequestURI();
            if (!string3.startsWith(string2)) {
                string2 = EncodingFunctions.encodeUrlPath(string2);
            }
            return string + string3.substring(string2.length());
        }
        return super.getRequestURI();
    }

    @Override
    public String getContextPath() {
        String string = ProxyHttpServletRequest.getProxyContext(this);
        if (string == null) {
            return super.getContextPath();
        }
        return string;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = ProxyHttpServletRequest.getHttpServerPort(this);
        stringBuffer.append(this.getRequestURI());
        return stringBuffer;
    }

    @Override
    public String getHeader(String name) {
        if (name.equalsIgnoreCase("host")) {
            try {
                int n2;
                String string = this.getParameter("http_server_port");
                if (string != null && (n2 = string.indexOf("://")) > 0) {
                    return string.substring(n2 + 3);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.getHeader(name);
    }

    @Override
    public boolean isSecure() {
        return ProxyHttpServletRequest.getHttpServerPort(this).toString().startsWith("https:");
    }

    @Override
    public HttpSession getSession() {
        if (this.b != null) {
            return this.b;
        }
        return super.getSession();
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this.b != null) {
            return this.b;
        }
        return super.getSession(create);
    }

    public static void setSession(ServletRequest request, HttpSession session) {
        while (request instanceof HttpServletRequestWrapper) {
            if (request instanceof ProxyHttpServletRequest) {
                ((ProxyHttpServletRequest)request).b = session;
            }
            request = ((HttpServletRequestWrapper)request).getRequest();
        }
    }

    public static String getProxyContext(@Nonnull HttpServletRequest req) {
        try {
            Object object = req.getParameter("application_context");
            if (object == null) {
                object = req.getHeader("X-Forwarded-Context");
            }
            if (object == null) {
                object = req.getHeader("X-Forwarded-Prefix");
            }
            if (object != null) {
                if (((String)object).endsWith("/")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                if (((String)object).length() > 0 && !((String)object).startsWith("/")) {
                    object = "/" + (String)object;
                }
            }
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static String getContextPath(@Nonnull HttpServletRequest req) {
        String string = ProxyHttpServletRequest.getProxyContext(req);
        if (string == null) {
            return req.getContextPath();
        }
        return string;
    }

    @SuppressFBWarnings(value={"SERVLET_SERVER_NAME"}, justification="Jetty already response with 'Bad Message 400 reason: No Host'")
    public static StringBuffer getHttpServerPort(@Nonnull HttpServletRequest req) {
        String string = null;
        try {
            string = req.getParameter("http_server_port");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string != null) {
            return new StringBuffer(string);
        }
        a a2 = new a();
        return a2.a(req);
    }

    public static boolean isProxyRequest(@Nonnull HttpServletRequest request) {
        return request.getHeader("X-Forwarded-Host") != null || request.getHeader("X-Forwarded-Server") != null;
    }

    @Override
    public String getServletPath() {
        try {
            return super.getServletPath();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.getRequestURI().substring(ServletUtils.getContextPathLength(this));
        }
    }
}

