/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.help;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigurationManager;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class HelpProviderImpl
implements HelpProvider {
    @Nonnull
    private String a;
    private URL b;
    private int c;
    private Permission[] d;
    private boolean e;

    public HelpProviderImpl(@Nonnull String helpSetName, int priority, Permission ... requiredPermission) {
        this(helpSetName, priority, false, requiredPermission);
    }

    public HelpProviderImpl(@Nonnull String helpSetName, int priority, boolean allPermissionsNeeded, Permission ... requiredPermission) {
        this.a(helpSetName, priority, this.getClass(), allPermissionsNeeded, requiredPermission);
    }

    @Deprecated
    public HelpProviderImpl(@Nonnull String helpPackage, String helpSetFileName, int priority, Permission ... requiredPermission) {
        this.a(helpPackage, helpSetFileName, priority, false, requiredPermission);
    }

    private void a(@Nonnull String string, int n2, @Nonnull Class<?> clazz, boolean bl, Permission ... permissionArray) {
        Package package_ = clazz.getPackage();
        Objects.requireNonNull(package_);
        Object object = package_.getName();
        object = ((String)object).replace('.', '/');
        object = (String)object + "/help";
        String string2 = string + ".hs";
        this.a((String)object, string2, n2, bl, permissionArray);
    }

    private void a(String object, String string, int n2, boolean bl, Permission ... permissionArray) {
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        this.a = (String)object + string;
        this.c = n2;
        this.e = bl;
        this.d = permissionArray == null ? null : Arrays.asList(permissionArray).stream().filter(permission -> permission != null).collect(Collectors.toList()).toArray(new Permission[0]);
    }

    @Override
    @Nonnull
    public String getHelpSetPath() {
        return this.a;
    }

    @Override
    @Nullable
    public URL getHelpSet() {
        if (this.b == null) {
            this.b = this.getClass().getResource(this.a);
        }
        return this.b;
    }

    @Override
    @Nonnull
    public String getHelpPackage() {
        return this.a.substring(0, this.a.lastIndexOf(47) + 1);
    }

    @Override
    public int getPriority() {
        return this.c;
    }

    @Override
    public boolean isVisible(@Nonnull HelpPage helpPage) {
        if (this.d != null && this.d.length > 0 && !ConfigurationManager.isHelpCenterMode()) {
            if (this.e) {
                for (Permission permission : this.d) {
                    if (SystemPermissionChecker.checkAccess(permission)) continue;
                    return false;
                }
            } else if (!SystemPermissionChecker.checkAccess(this.d)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.a;
    }

    @Override
    public int compareTo(@Nonnull HelpProvider o2) {
        int n2 = this.getPriority() - o2.getPriority();
        if (n2 == 0) {
            return this.getHelpSetPath().compareTo(o2.getHelpSetPath());
        }
        return n2;
    }
}

