/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.fs;

import com.inet.lib.util.IOFunctions;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.b;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;

public class ZipResourceFile
implements ResourceFile {
    private final ZipFile a;
    private final ZipEntry b;

    public ZipResourceFile(ZipFile zipFile, String pathname) {
        this(zipFile, ZipResourceFile.a(zipFile, pathname));
    }

    public ZipResourceFile(ZipFile zipFile, ZipEntry entry) {
        this.a = zipFile;
        this.b = entry;
    }

    @Nonnull
    private static ZipEntry a(ZipFile zipFile, String string) {
        Object object = string;
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (string2.equals(string)) {
                return zipEntry;
            }
            if (!string2.startsWith((String)object)) continue;
            return new ZipEntry((String)object);
        }
        return new ZipEntry(string);
    }

    @Override
    @Nonnull
    public ResourceFile createChild(@Nonnull String child) {
        String string = ResourceFile.createNormalizeChildPath(this.b.getName(), child);
        return new ZipResourceFile(this.a, string);
    }

    @Override
    public String getName() {
        String string = this.b.getName();
        int n2 = string.lastIndexOf(47);
        if (string.length() > 1 && n2 == string.length() - 1) {
            int n3 = string.lastIndexOf(47, n2 - 1);
            if (n3 >= 0) {
                return string.substring(n3 + 1, n2);
            }
            return string.substring(0, n2);
        }
        return string.substring(n2 + 1);
    }

    @Override
    public boolean isDirectory() {
        return this.b.isDirectory();
    }

    @Override
    public boolean exists() {
        String string = this.b.getName();
        Object object = string;
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        if (((String)object).equals("/")) {
            return true;
        }
        Enumeration<? extends ZipEntry> enumeration = this.a.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (string2.equals(string)) {
                return true;
            }
            if (!string2.startsWith((String)object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getAbsolutePath() {
        return this.a.getName() + "/" + this.b.getName();
    }

    @Override
    public ResourceFile[] listFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        String string = this.getPath();
        if (string.equals("/")) {
            string = "";
        }
        int n2 = string.length();
        HashSet<ZipResourceFile> hashSet = new HashSet<ZipResourceFile>();
        Enumeration<? extends ZipEntry> enumeration = this.a.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (string2.length() <= n2 || !string2.startsWith(string)) continue;
            int n3 = string2.indexOf(47, n2 + 1);
            if (n3 < 0) {
                hashSet.add(new ZipResourceFile(this.a, zipEntry));
                continue;
            }
            hashSet.add(new ZipResourceFile(this.a, string2.substring(0, n3 + 1)));
        }
        return hashSet.toArray(new ResourceFile[hashSet.size()]);
    }

    @Override
    public ArchiveFile createArchiveFile() throws ZipException, IOException {
        return new b(this.a, this.b);
    }

    @Override
    public String getPath() {
        return this.b.getName();
    }

    @Override
    public long lastModified() {
        return this.b.getTime();
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.getPath().equals(((ZipResourceFile)obj).getPath());
    }

    @Override
    @Nonnull
    public URL getURL() throws MalformedURLException {
        return new URL("jar", null, String.valueOf(IOFunctions.getFileURL(this.a.getName())) + "!/" + this.b.getName());
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws FileNotFoundException {
        try {
            return this.a.getInputStream(this.b);
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(iOException.getMessage());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    @Override
    public long length() {
        return this.b.getSize();
    }
}

