/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.spi;

import com.inet.annotations.InternalApi;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.EventLog;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class PersistenceHelper {
    public static final DateTimeFormatter ISO_INSTANT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX").withZone(ZoneOffset.UTC);

    private PersistenceHelper() {
    }

    @Nonnull
    public static String checkName(String path) throws IllegalArgumentException {
        int n2;
        Objects.requireNonNull(path);
        path = ((String)path).replace('\\', '/');
        int n3 = ((String)path).length();
        block6: for (n2 = 0; n2 < n3; ++n2) {
            char c2 = ((String)path).charAt(n2);
            switch (c2) {
                case '*': 
                case ':': 
                case '?': {
                    throw new IllegalArgumentException("Invalid persistence key: " + (String)path);
                }
                case '/': {
                    if (n2 <= 0 || ((String)path).charAt(n2 - 1) != '/') continue block6;
                    throw new IllegalArgumentException("Invalid persistence key: " + (String)path);
                }
                case '.': {
                    if (n2 <= 0 || ((String)path).charAt(n2 - 1) != '.') continue block6;
                    throw new IllegalArgumentException("Invalid persistence key: " + (String)path);
                }
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case '-': 
                case '_': {
                    continue block6;
                }
                default: {
                    if (Character.isLetterOrDigit(c2)) continue block6;
                    throw new IllegalArgumentException("Invalid persistence key: " + (String)path);
                }
            }
        }
        if (n3 > 1 && ((String)path).charAt(n3 - 1) == '/') {
            path = ((String)path).substring(0, n3 - 1);
        }
        if (((String)path).isEmpty() || ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        int n4 = n2 = ((String)path).length() == 1 ? 0 : ((String)path).substring(((String)path).lastIndexOf(47) + 1).length();
        if (n2 > 100) {
            throw new IllegalArgumentException("Invalid persistence key: " + (String)path + ". The length of the last segment must not exceed 100 characters.");
        }
        return path;
    }

    @Nonnull
    public static String resolve(@Nonnull String parent, @Nonnull String child) {
        block2: {
            int n2;
            int n3;
            if (!((String)child).startsWith("/")) {
                Object object = child = parent.endsWith("/") ? parent + (String)child : parent + "/" + (String)child;
            }
            while ((n3 = ((String)child).indexOf("/../")) > 0) {
                n2 = ((String)child).lastIndexOf(47, n3 - 1);
                child = ((String)child).substring(0, n2 + 1) + ((String)child).substring(n3 + 4, ((String)child).length());
            }
            if (!((String)child).endsWith("/..") || (n3 = ((String)child).length() - 3) <= 0) break block2;
            n2 = ((String)child).lastIndexOf(47, n3 - 1);
            child = ((String)child).substring(0, n2 + 1);
        }
        return child;
    }

    public static String getParentPath(@Nonnull String path) {
        int n2 = path.lastIndexOf(47, path.length() - 2);
        if (n2 < 0) {
            return null;
        }
        if (n2 == 0) {
            return "/";
        }
        return path.substring(0, n2);
    }

    @Nonnull
    public static String getName(@Nonnull String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String searchPatternToRegex(String pattern) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('^');
        boolean bl = false;
        int n2 = pattern.length();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = pattern.charAt(i2);
            switch (c2) {
                case '?': {
                    if (bl) {
                        stringBuilder.append("\\E");
                        bl = false;
                    }
                    int n3 = 1;
                    while (i2 + 1 < n2 && pattern.charAt(i2 + 1) == '?') {
                        ++n3;
                        ++i2;
                    }
                    stringBuilder.append(".{").append(n3).append('}');
                    continue block5;
                }
                case '*': {
                    if (bl) {
                        stringBuilder.append("\\E");
                        bl = false;
                    }
                    stringBuilder.append(".*");
                    continue block5;
                }
                case '[': {
                    if (bl) {
                        stringBuilder.append("\\E");
                        bl = false;
                    }
                    stringBuilder.append(c2);
                    while (c2 != ']') {
                        c2 = pattern.charAt(++i2);
                        stringBuilder.append(c2);
                    }
                    continue block5;
                }
                default: {
                    if (!bl) {
                        stringBuilder.append("\\Q");
                        bl = true;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        if (bl) {
            stringBuilder.append("\\E");
        }
        return stringBuilder.toString();
    }

    public static void appendTo(StringBuilder builder, EventLog.EventData eventData) {
        ISO_INSTANT.formatTo(Instant.ofEpochMilli(eventData.getTimeMillis()), builder);
        builder.append(',');
        if (eventData.getAccount() == null) {
            builder.append(',');
        } else {
            PersistenceHelper.appendQuotedString(builder, eventData.getAccount().getID().toString());
            builder.append(',');
            PersistenceHelper.appendQuotedString(builder, eventData.getAccount().getDisplayName());
        }
        builder.append(',');
        PersistenceHelper.appendQuotedString(builder, eventData.getEvent());
        builder.append(',');
        PersistenceHelper.appendQuotedString(builder, eventData.getMessage());
        builder.append(',');
        PersistenceHelper.appendQuotedString(builder, eventData.getData());
        if (eventData.getExtraColumns() != null) {
            for (Object object : eventData.getExtraColumns()) {
                builder.append(',');
                if (object == null) continue;
                if (object instanceof Number) {
                    builder.append(object);
                    continue;
                }
                PersistenceHelper.appendQuotedString(builder, object.toString());
            }
        }
    }

    public static void appendQuotedString(@Nonnull StringBuilder builder, @Nullable String value) {
        if (value == null) {
            return;
        }
        builder.append('\"');
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (c2 == '\"') {
                builder.append('\"');
            }
            builder.append(c2);
        }
        builder.append('\"');
    }

    public static boolean parseEventLine(@Nullable String line, String @Nonnull [] target) {
        if (StringFunctions.isEmpty(line)) {
            return false;
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = line.length();
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = line.charAt(i2);
            switch (c2) {
                case '\"': {
                    if (bl) {
                        int n4 = i2 + 1;
                        if (n4 < n3 && line.charAt(n4) == '\"') {
                            ++i2;
                            stringBuilder.append(c2);
                            continue block4;
                        }
                        bl = false;
                        continue block4;
                    }
                    bl = true;
                    stringBuilder.setLength(0);
                    continue block4;
                }
                case ',': {
                    if (bl) {
                        stringBuilder.append(c2);
                        continue block4;
                    }
                    target[n2++] = stringBuilder.toString();
                    if (n2 == target.length) {
                        return true;
                    }
                    stringBuilder.setLength(0);
                    continue block4;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        target[n2++] = stringBuilder.toString();
        while (n2 < target.length) {
            target[n2] = "";
            ++n2;
        }
        return true;
    }
}

